/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.lbs.api;

import cn.vertxup.lbs.domain.tables.daos.LCityDao;
import cn.vertxup.lbs.domain.tables.daos.LCountryDao;
import cn.vertxup.lbs.domain.tables.daos.LFloorDao;
import cn.vertxup.lbs.domain.tables.daos.LRegionDao;
import cn.vertxup.lbs.domain.tables.daos.LStateDao;
import cn.vertxup.lbs.domain.tables.daos.LTentDao;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Queue;
import io.vertx.up.commune.Envelop;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.function.Supplier;

@Queue
public class QueryActor {
    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0394\u03b9\u03b5\u03cd\u03b8\u03c5\u03bd\u03c3\u03b7/L-COUNTRIES")
    public Future<JsonArray> queryCountries(Envelop request) {
        return Ux.Jooq.on(LCountryDao.class).fetchAllAsync().compose(Ux::futureA);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0394\u03b9\u03b5\u03cd\u03b8\u03c5\u03bd\u03c3\u03b7/L-STATE/BY-COUNTRY")
    public Future<JsonArray> queryStates(String countryId) {
        return Ux.Jooq.on(LStateDao.class).fetchAsync("countryId", (Object)countryId).compose(Ux::futureA);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0394\u03b9\u03b5\u03cd\u03b8\u03c5\u03bd\u03c3\u03b7/L-CITY/BY-STATE")
    public Future<JsonArray> queryCities(String stateId) {
        return Ux.Jooq.on(LCityDao.class).fetchAsync("stateId", (Object)stateId).compose(Ux::futureA);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0394\u03b9\u03b5\u03cd\u03b8\u03c5\u03bd\u03c3\u03b7/L-REGION/BY-CITY")
    public Future<JsonArray> queryRegions(String cityId) {
        return Ux.Jooq.on(LRegionDao.class).fetchAsync("cityId", (Object)cityId).compose(Ux::futureA);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0394\u03b9\u03b5\u03cd\u03b8\u03c5\u03bd\u03c3\u03b7/L-TENT/BY-SIGMA")
    public Future<JsonArray> getTents(String sigma) {
        return Ux.Jooq.on(LTentDao.class).fetchAsync("sigma", (Object)sigma).compose(Ux::futureA);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0394\u03b9\u03b5\u03cd\u03b8\u03c5\u03bd\u03c3\u03b7/L-FLOOR/BY-SIGMA")
    public Future<JsonArray> getFloors(String sigma) {
        return Ux.Jooq.on(LFloorDao.class).fetchAsync("sigma", (Object)sigma).compose(Ux::futureA);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0394\u03b9\u03b5\u03cd\u03b8\u03c5\u03bd\u03c3\u03b7/L-REGION/META")
    public Future<JsonObject> initRegion(String id) {
        JsonObject response = new JsonObject();
        return Ux.future((Object)id).compose(regionId -> this.combine(response, "regionId", () -> regionId)).compose(regionId -> Ux.Jooq.on(LRegionDao.class).fetchByIdAsync(regionId)).compose(region -> this.combine(response, "cityId", region::getCityId)).compose(cityId -> Ux.Jooq.on(LCityDao.class).fetchByIdAsync(cityId)).compose(city -> this.combine(response, "stateId", city::getStateId)).compose(stateId -> Ux.Jooq.on(LStateDao.class).fetchByIdAsync(stateId)).compose(state -> this.combine(response, "countryId", state::getCountryId)).compose(countryId -> Ux.future((Object)response));
    }

    private Future<String> combine(JsonObject data, String field, Supplier<String> valueFun) {
        String value = valueFun.get();
        if (Ut.isNotNil((String)value)) {
            data.put(field, (Object)value);
        }
        return Ux.future((Object)value);
    }
}

