/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.wall;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.ext.web.handler.AuthHandler;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.tp.rbac.service.jwt.JwtStub;
import io.vertx.up.aiki.Ux;
import io.vertx.up.annotations.Authenticate;
import io.vertx.up.annotations.Wall;
import io.vertx.up.log.Annal;
import io.vertx.up.secure.Security;
import io.vertx.up.secure.handler.JwtOstium;
import io.vertx.up.secure.provider.JwtAuth;
import javax.inject.Inject;

@Wall(value="jwt", path="/api/*")
public class JwtWall
implements Security {
    private static final Annal LOGGER = Annal.get(JwtWall.class);
    @Inject
    private transient JwtStub jwtStub;

    @Authenticate
    public AuthHandler authenticate(Vertx vertx, JsonObject config) {
        return JwtOstium.create((JwtAuth)JwtAuth.create((Vertx)vertx, (JWTAuthOptions)new JWTAuthOptions(config)).bind(() -> this));
    }

    public Future<JsonObject> store(JsonObject data) {
        String userKey = data.getString("user");
        Sc.infoAuth(LOGGER, "The system will initialize user''s principle information. user key: {0}.", userKey);
        return this.jwtStub.store(userKey, data);
    }

    public Future<Boolean> verify(JsonObject data) {
        String token = data.getString("jwt");
        JsonObject extracted = Ux.Jwt.extract((JsonObject)data);
        Sc.infoAuth(LOGGER, "The system will verify token = {0}", token, extracted.encode());
        return this.jwtStub.verify(extracted.getString("user"), token);
    }

    public Future<Boolean> access(JsonObject data) {
        System.out.println(data.encodePrettily());
        return Future.succeededFuture((Object)Boolean.TRUE);
    }
}

