/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.authority;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.authority.ProfileGroup;
import io.vertx.tp.rbac.authority.ProfileRole;
import io.vertx.tp.rbac.authority.ProfileType;
import io.zero.epic.Ut;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class Assembler {
    public static List<ProfileRole> connect(List<ProfileRole> profiles, List<ProfileGroup> original) {
        Set originalSet = original.stream().flatMap(group -> group.getRoles().stream()).collect(Collectors.toSet());
        originalSet.addAll(profiles);
        return new ArrayList<ProfileRole>(originalSet);
    }

    public static List<ProfileRole> connect(List<ProfileRole> profiles, ProfileGroup original) {
        HashSet<ProfileRole> originalSet = new HashSet<ProfileRole>(original.getRoles());
        originalSet.addAll(profiles);
        return new ArrayList<ProfileRole>(originalSet);
    }

    public static Consumer<JsonObject> union(ProfileType type, List<ProfileRole> profiles) {
        return Assembler.bind(type, profiles, Ut::union);
    }

    public static Consumer<JsonObject> intersect(ProfileType type, List<ProfileRole> profiles) {
        return Assembler.bind(type, profiles, Ut::intersect);
    }

    public static Consumer<JsonObject> eager(ProfileType type, List<ProfileRole> profiles) {
        return Assembler.bind(type, profiles, true);
    }

    public static Consumer<JsonObject> lazy(ProfileType type, List<ProfileRole> profiles) {
        return Assembler.bind(type, profiles, false);
    }

    private static Consumer<JsonObject> bind(ProfileType type, List<ProfileRole> profiles, BinaryOperator<Set<String>> fnReduce) {
        return input -> {
            if (Objects.nonNull(input) && !profiles.isEmpty()) {
                ProfileRole first = (ProfileRole)profiles.iterator().next();
                Set permissionIds = profiles.stream().filter(Objects::nonNull).map(ProfileRole::getAuthorities).reduce(first.getAuthorities(), fnReduce);
                JsonArray data = Ut.toJArray((Set)permissionIds);
                input.put(type.getKey(), data);
            } else {
                input.put(type.getKey(), new JsonArray());
            }
        };
    }

    private static Consumer<JsonObject> bind(ProfileType type, List<ProfileRole> profiles, boolean highPriority) {
        return input -> {
            if (Objects.nonNull(input) && !profiles.isEmpty()) {
                Set found = highPriority ? (Set)profiles.stream().min(Comparator.comparing(ProfileRole::getPriority)).map(ProfileRole::getAuthorities).orElse(new HashSet()) : (Set)profiles.stream().max(Comparator.comparing(ProfileRole::getPriority)).map(ProfileRole::getAuthorities).orElse(new HashSet());
                JsonArray data = Ut.toJArray((Set)found);
                input.put(type.getKey(), data);
            } else {
                input.put(type.getKey(), new JsonArray());
            }
        };
    }
}

