/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.authority;

import cn.vertxup.domain.tables.daos.RRolePermDao;
import cn.vertxup.domain.tables.pojos.RRolePerm;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.atom.ScConfig;
import io.vertx.tp.rbac.authority.ProfileGroup;
import io.vertx.tp.rbac.init.ScPin;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.aiki.Ux;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ProfileRole
implements Serializable {
    private static final ScConfig CONFIG = ScPin.getConfig();
    private final transient String roleId;
    private final transient Integer priority;
    private final transient Set<String> authorities = new HashSet<String>();
    private transient ProfileGroup reference;

    ProfileRole(JsonObject data) {
        this.roleId = data.getString("roleId");
        this.priority = data.getInteger("priority");
    }

    public Future<ProfileRole> initAsync() {
        boolean isSecondary = CONFIG.getSupportSecondary();
        return isSecondary ? this.fetchAuthoritiesAsyncWithCache().compose(ids -> Future.succeededFuture((Object)this)) : this.fetchAuthoritiesAsync().compose(ids -> Future.succeededFuture((Object)this));
    }

    public ProfileRole init() {
        JsonArray permissions = this.fetchAuthorities();
        return this;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getKey() {
        return this.roleId;
    }

    Set<String> getAuthorities() {
        return this.authorities;
    }

    public ProfileGroup getGroup() {
        return this.reference;
    }

    public ProfileRole setGroup(ProfileGroup reference) {
        this.reference = reference;
        return this;
    }

    private Future<JsonArray> fetchAuthoritiesAsyncWithCache() {
        return Sc.cachePermission(this.roleId).compose(array -> {
            if (Objects.isNull(array)) {
                return this.fetchAuthoritiesAsync().compose(data -> Sc.cachePermission(this.roleId, data));
            }
            array.stream().map(item -> (String)item).forEach(this.authorities::add);
            return Future.succeededFuture((Object)array);
        });
    }

    private Future<JsonArray> fetchAuthoritiesAsync() {
        return Ux.Jooq.on(RRolePermDao.class).fetchAsync("roleId", (Object)this.roleId).compose(this::refreshAuthoritiesAsync);
    }

    private JsonArray fetchAuthorities() {
        return this.refreshAuthorities(Ux.Jooq.on(RRolePermDao.class).fetch("roleId", (Object)this.roleId));
    }

    private Future<JsonArray> refreshAuthoritiesAsync(List<RRolePerm> permissions) {
        return Future.succeededFuture((Object)this.refreshAuthorities(permissions));
    }

    private JsonArray refreshAuthorities(List<RRolePerm> permissions) {
        List permissionIds = permissions.stream().filter(Objects::nonNull).map(RRolePerm::getPermId).collect(Collectors.toList());
        this.authorities.clear();
        this.authorities.addAll(permissionIds);
        return new JsonArray(permissionIds);
    }

    public String toString() {
        return "ProfileRole{roleId='" + this.roleId + '\'' + ", priority=" + this.priority + ", authorities=" + this.authorities + ", reference=" + this.reference + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProfileRole)) {
            return false;
        }
        ProfileRole that = (ProfileRole)o;
        return this.roleId.equals(that.roleId);
    }

    public int hashCode() {
        return Objects.hash(this.roleId);
    }
}

