/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.authority;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.authority.Pool;
import io.vertx.tp.rbac.authority.ProfileGroup;
import io.vertx.tp.rbac.authority.ProfileRole;
import io.vertx.tp.rbac.authority.child.GcCritical;
import io.vertx.tp.rbac.authority.child.GcHorizon;
import io.vertx.tp.rbac.authority.child.GcOverlook;
import io.vertx.tp.rbac.authority.detent.ScDetentChild;
import io.vertx.tp.rbac.authority.detent.ScDetentExtend;
import io.vertx.tp.rbac.authority.detent.ScDetentGroup;
import io.vertx.tp.rbac.authority.detent.ScDetentInherit;
import io.vertx.tp.rbac.authority.detent.ScDetentParent;
import io.vertx.tp.rbac.authority.detent.ScDetentRole;
import io.vertx.tp.rbac.authority.direct.GdCritical;
import io.vertx.tp.rbac.authority.direct.GdHorizon;
import io.vertx.tp.rbac.authority.direct.GdOverlook;
import io.vertx.tp.rbac.authority.extend.GeCritical;
import io.vertx.tp.rbac.authority.extend.GeHorizon;
import io.vertx.tp.rbac.authority.extend.GeOverlook;
import io.vertx.tp.rbac.authority.inherit.GiCritical;
import io.vertx.tp.rbac.authority.inherit.GiHorizon;
import io.vertx.tp.rbac.authority.inherit.GiOverlook;
import io.vertx.tp.rbac.authority.parent.GpCritical;
import io.vertx.tp.rbac.authority.parent.GpHorizon;
import io.vertx.tp.rbac.authority.parent.GpOverlook;
import io.vertx.up.aiki.Ux;
import io.zero.epic.fn.Fn;
import java.util.List;

public interface ScDetent {
    public static ScDetent user(JsonObject input) {
        return new ScDetentRole(input);
    }

    public static ScDetent group(JsonObject input) {
        return new ScDetentGroup(input);
    }

    public static ScDetent parent(JsonObject input, List<ProfileGroup> profiles) {
        return new ScDetentParent(input, profiles);
    }

    public static ScDetent inherit(JsonObject input, List<ProfileGroup> profiles) {
        return new ScDetentInherit(input, profiles);
    }

    public static ScDetent extend(JsonObject input, List<ProfileGroup> profiles) {
        return new ScDetentExtend(input, profiles);
    }

    public static ScDetent children(JsonObject input, List<ProfileGroup> profiles) {
        return new ScDetentChild(input, profiles);
    }

    public JsonObject proc(List<ProfileRole> var1);

    default public Future<JsonObject> procAsync(List<ProfileRole> profiles) {
        return Ux.toFuture((Object)this.proc(profiles));
    }

    public static interface Group {
        public static ScDetent horizon() {
            return (ScDetent)Fn.pool(Pool.DETENT_POOL, (Object)GdHorizon.class.getName(), GdHorizon::new);
        }

        public static ScDetent critical() {
            return (ScDetent)Fn.pool(Pool.DETENT_POOL, (Object)GdCritical.class.getName(), GdCritical::new);
        }

        public static ScDetent overlook() {
            return (ScDetent)Fn.pool(Pool.DETENT_POOL, (Object)GdOverlook.class.getName(), GdOverlook::new);
        }

        public static interface Extend {
            public static ScDetent horizon(List<ProfileGroup> original) {
                return new GeHorizon(original);
            }

            public static ScDetent critical(List<ProfileGroup> original) {
                return new GeCritical(original);
            }

            public static ScDetent overlook(List<ProfileGroup> original) {
                return new GeOverlook(original);
            }
        }

        public static interface Inherit {
            public static ScDetent horizon(List<ProfileGroup> original) {
                return new GiHorizon(original);
            }

            public static ScDetent critical(List<ProfileGroup> original) {
                return new GiCritical(original);
            }

            public static ScDetent overlook(List<ProfileGroup> original) {
                return new GiOverlook(original);
            }
        }

        public static interface Child {
            public static ScDetent horizon() {
                return (ScDetent)Fn.pool(Pool.DETENT_POOL, (Object)GcHorizon.class.getName(), GcHorizon::new);
            }

            public static ScDetent critical(List<ProfileGroup> original) {
                return new GcCritical(original);
            }

            public static ScDetent overlook(List<ProfileGroup> original) {
                return new GcOverlook(original);
            }
        }

        public static interface Parent {
            public static ScDetent horizon() {
                return (ScDetent)Fn.pool(Pool.DETENT_POOL, (Object)GpHorizon.class.getName(), GpHorizon::new);
            }

            public static ScDetent critical(List<ProfileGroup> original) {
                return new GpCritical(original);
            }

            public static ScDetent overlook(List<ProfileGroup> original) {
                return new GpOverlook(original);
            }
        }
    }
}

