/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.authority;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.authority.Align;
import io.vertx.tp.rbac.authority.ProfileGroup;
import io.vertx.tp.rbac.authority.ProfileRole;
import io.vertx.tp.rbac.authority.ScDetent;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.aiki.Uson;
import io.vertx.up.aiki.Ux;
import io.vertx.up.log.Annal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ScSession {
    private static final Annal LOGGER = Annal.get(ScSession.class);

    public static Future<Boolean> initAuthorization(JsonObject data) {
        String userKey = data.getString("user");
        JsonObject authority = new JsonObject();
        return Sc.cacheAuthority(userKey).compose(item -> {
            if (null == item) {
                return ScSession.initRoles(authority, data.getJsonArray("role")).compose(processed -> ScSession.initGroups(processed, data.getJsonArray("group"))).compose(result -> Uson.create((JsonObject)data).append("profile", (Object)authority).toFuture()).compose(session -> Sc.cacheAuthority(userKey, session)).compose(ScSession::onReport).compose(nil -> Ux.toFuture((Object)Boolean.TRUE));
            }
            authority.mergeIn(item);
            return Ux.toFuture((Object)Boolean.TRUE);
        });
    }

    private static Future<JsonObject> initRoles(JsonObject authority, JsonArray roles) {
        Sc.infoAuth(LOGGER, "Roles : {0}", roles.encode());
        ArrayList futures = new ArrayList();
        roles.stream().filter(Objects::nonNull).map(item -> (JsonObject)item).map(ProfileRole::new).map(ProfileRole::initAsync).forEach(futures::add);
        return CompositeFuture.all(futures).compose(Sc::composite).compose(ScDetent.user(authority)::procAsync);
    }

    private static Future<JsonObject> initGroups(JsonObject authority, JsonArray groups) {
        Sc.infoAuth(LOGGER, "Groups: {0}", groups.encode());
        ArrayList futures = new ArrayList();
        groups.stream().filter(Objects::nonNull).map(item -> (JsonObject)item).map(ProfileGroup::new).map(ProfileGroup::initAsync).forEach(futures::add);
        return CompositeFuture.all(futures).compose(Sc::composite).compose(profiles -> Ux.toFuture((Object)profiles).compose(Align::flat).compose(ScDetent.group(authority)::procAsync).compose(nil -> Ux.toFuture((Object)profiles)).compose(Align::parent).compose(parents -> ScDetent.parent(authority, profiles).procAsync((List<ProfileRole>)parents).compose(nil -> ScDetent.inherit(authority, profiles).procAsync((List<ProfileRole>)parents))).compose(nil -> Ux.toFuture((Object)profiles)).compose(Align::children).compose(children -> ScDetent.children(authority, profiles).procAsync((List<ProfileRole>)children).compose(nil -> ScDetent.extend(authority, profiles).procAsync((List<ProfileRole>)children))).compose(nil -> Ux.toFuture((Object)profiles))).compose(nil -> Ux.toFuture((Object)authority));
    }

    private static Future<JsonObject> onReport(JsonObject result) {
        Sc.infoAuth(LOGGER, "Permissions: \n{0}", result.encodePrettily());
        return Future.succeededFuture((Object)result);
    }
}

