/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.authority.extend;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.authority.Align;
import io.vertx.tp.rbac.authority.Amalgam;
import io.vertx.tp.rbac.authority.Assembler;
import io.vertx.tp.rbac.authority.ProfileGroup;
import io.vertx.tp.rbac.authority.ProfileRole;
import io.vertx.tp.rbac.authority.ProfileType;
import io.vertx.tp.rbac.authority.ScDetent;
import java.util.List;

public class GeOverlook
implements ScDetent {
    private final transient List<ProfileGroup> original;

    public GeOverlook(List<ProfileGroup> original) {
        this.original = original;
    }

    private List<ProfileRole> before(List<ProfileRole> profiles) {
        ProfileGroup lazy = Align.lazy(this.original);
        List<ProfileRole> source = Amalgam.children(profiles, lazy);
        List<ProfileRole> processed = Amalgam.lazy(source);
        return Assembler.connect(processed, lazy);
    }

    @Override
    public JsonObject proc(List<ProfileRole> profiles) {
        JsonObject group = new JsonObject();
        List<ProfileRole> source = this.before(profiles);
        Amalgam.logGroup(this.getClass(), source);
        Assembler.union(ProfileType.EXTEND_OVERLOOK_UNION, source).accept(group);
        Assembler.eager(ProfileType.EXTEND_OVERLOOK_EAGER, source).accept(group);
        Assembler.lazy(ProfileType.EXTEND_OVERLOOK_LAZY, source).accept(group);
        Assembler.intersect(ProfileType.EXTEND_OVERLOOK_INTERSECT, source).accept(group);
        return group;
    }
}

