/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.authority.inherit;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.authority.Align;
import io.vertx.tp.rbac.authority.Amalgam;
import io.vertx.tp.rbac.authority.Assembler;
import io.vertx.tp.rbac.authority.ProfileGroup;
import io.vertx.tp.rbac.authority.ProfileRole;
import io.vertx.tp.rbac.authority.ProfileType;
import io.vertx.tp.rbac.authority.ScDetent;
import java.util.List;

public class GiOverlook
implements ScDetent {
    private final transient List<ProfileGroup> original;

    public GiOverlook(List<ProfileGroup> original) {
        this.original = original;
    }

    private List<ProfileRole> before(List<ProfileRole> profiles) {
        ProfileGroup lazy = Align.lazy(this.original);
        List<ProfileRole> source = Amalgam.parent(profiles, lazy);
        List<ProfileRole> processed = Amalgam.lazy(source);
        return Assembler.connect(processed, lazy);
    }

    @Override
    public JsonObject proc(List<ProfileRole> profiles) {
        JsonObject group = new JsonObject();
        List<ProfileRole> source = this.before(profiles);
        Amalgam.logGroup(this.getClass(), source);
        Assembler.union(ProfileType.INHERIT_OVERLOOK_UNION, source).accept(group);
        Assembler.eager(ProfileType.INHERIT_OVERLOOK_EAGER, source).accept(group);
        Assembler.lazy(ProfileType.INHERIT_OVERLOOK_LAZY, source).accept(group);
        Assembler.intersect(ProfileType.INHERIT_OVERLOOK_INTERSECT, source).accept(group);
        return group;
    }
}

