/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.authority.parent;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.authority.Align;
import io.vertx.tp.rbac.authority.Amalgam;
import io.vertx.tp.rbac.authority.Assembler;
import io.vertx.tp.rbac.authority.ProfileGroup;
import io.vertx.tp.rbac.authority.ProfileRole;
import io.vertx.tp.rbac.authority.ProfileType;
import io.vertx.tp.rbac.authority.ScDetent;
import java.util.List;

public class GpCritical
implements ScDetent {
    private final transient List<ProfileGroup> original;

    public GpCritical(List<ProfileGroup> original) {
        this.original = original;
    }

    private List<ProfileRole> before(List<ProfileRole> profiles) {
        ProfileGroup eager = Align.eager(this.original);
        List<ProfileRole> source = Amalgam.parent(profiles, eager);
        return Amalgam.eager(source);
    }

    @Override
    public JsonObject proc(List<ProfileRole> profiles) {
        JsonObject group = new JsonObject();
        List<ProfileRole> source = this.before(profiles);
        Amalgam.logGroup(this.getClass(), source);
        Assembler.union(ProfileType.PARENT_CRITICAL_UNION, source).accept(group);
        Assembler.eager(ProfileType.PARENT_CRITICAL_EAGER, source).accept(group);
        Assembler.lazy(ProfileType.PARENT_CRITICAL_LAZY, source).accept(group);
        Assembler.intersect(ProfileType.PARENT_CRITICAL_INTERSECT, source).accept(group);
        return group;
    }
}

