/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.refine;

import io.vertx.core.Future;
import io.vertx.tp.rbac.atom.ScConfig;
import io.vertx.tp.rbac.init.ScPin;
import io.vertx.up.aiki.Ux;

class ScCache {
    private static final ScConfig CONFIG = ScPin.getConfig();

    ScCache() {
    }

    static <V> Future<V> code(String key) {
        String codePool = CONFIG.getCodePool();
        return Ux.Pool.on((String)codePool).remove((Object)key).compose(value -> Ux.toFuture((Object)value.getValue()));
    }

    static <V> Future<V> code(String key, V value) {
        String codePool = CONFIG.getCodePool();
        Integer codeExpired = CONFIG.getCodeExpired();
        return Ux.Pool.on((String)codePool).put((Object)key, value, codeExpired.intValue()).compose(item -> Ux.toFuture((Object)item.getValue()));
    }

    static <V> Future<V> authority(String key) {
        String tokenPool = CONFIG.getTokenPool();
        return Ux.Pool.on((String)tokenPool).get((Object)key);
    }

    static <V> Future<V> authority(String key, V value) {
        String tokenPool = CONFIG.getTokenPool();
        return Ux.Pool.on((String)tokenPool).put((Object)key, value).compose(item -> Ux.toFuture((Object)item.getValue()));
    }

    static <V> Future<V> permission(String key) {
        String permissionPool = CONFIG.getPermissionPool();
        return Ux.Pool.on((String)permissionPool).get((Object)key);
    }

    static <V> Future<V> permission(String key, V value) {
        String permissionPool = CONFIG.getPermissionPool();
        return Ux.Pool.on((String)permissionPool).put((Object)key, value).compose(item -> Ux.toFuture((Object)item.getValue()));
    }
}

