/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.refine;

import cn.vertxup.domain.tables.pojos.OAccessToken;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._401TokenCounterException;
import io.vertx.tp.error._401TokenExpiredException;
import io.vertx.tp.error._401TokenInvalidException;
import io.vertx.tp.rbac.atom.ScConfig;
import io.vertx.tp.rbac.init.ScPin;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.aiki.Uson;
import io.vertx.up.aiki.Ux;
import io.vertx.up.exception.WebException;
import io.vertx.up.log.Annal;
import io.vertx.zero.eon.Values;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;

class ScToken {
    private static final Annal LOGGER = Annal.get(ScToken.class);
    private static final ScConfig CONFIG = ScPin.getConfig();

    ScToken() {
    }

    static Future<Boolean> jwtToken(List<OAccessToken> item, String userId) {
        WebException error = null;
        if (null == item) {
            Sc.infoAuth(LOGGER, "Token size invalid ( null ): {0}, user: {1}.", item, userId);
            error = new _401TokenCounterException(ScToken.class, 0, userId);
        } else if (item.isEmpty()) {
            Sc.infoAuth(LOGGER, "Token size invalid ( empty ): {0}, user: {1}.", item, userId);
            error = new _401TokenCounterException(ScToken.class, 0, userId);
        } else if (1 < item.size()) {
            Sc.infoAuth(LOGGER, "Token size invalid ( multi ): {0}, user: {1}.", item, userId);
            error = new _401TokenCounterException(ScToken.class, item.size(), userId);
        } else {
            OAccessToken token = item.get(0);
            String tokenString = new String(token.getToken(), Values.CHARSET);
            byte[] authBytes = userId.getBytes(Values.CHARSET);
            if (Arrays.equals(authBytes, token.getAuth())) {
                long currentTime = new Date().getTime();
                long tokenTime = token.getExpiredTime();
                if (tokenTime < currentTime) {
                    Sc.infoAuth(LOGGER, "Token you provided {0} is expired at: {1}.", tokenString, tokenTime);
                    error = new _401TokenExpiredException(ScToken.class, tokenString);
                }
            } else {
                Sc.infoAuth(LOGGER, "Token invalid {0}", tokenString);
                error = new _401TokenInvalidException(ScToken.class, tokenString);
            }
        }
        if (null == error) {
            return Ux.toFuture((Object)Boolean.TRUE);
        }
        return Future.failedFuture((Throwable)error);
    }

    static JsonObject jwtToken(JsonObject data) {
        JsonObject tokenData = Uson.create((JsonObject)data.copy()).remove(new String[]{"role", "group"}).to();
        Sc.infoAuth(LOGGER, "Jwt token data stored: {0}.", tokenData.encode());
        String token = Ux.Jwt.token((JsonObject)tokenData);
        JsonObject response = new JsonObject();
        response.put("access_token", token);
        String refreshToken = Ux.Jwt.token((JsonObject)response.copy());
        response.put("refresh_token", refreshToken);
        Long iat = new Date().getTime() + CONFIG.getTokenExpired();
        response.put("iat", iat);
        return response;
    }

    static OAccessToken jwtToken(JsonObject jwt, String userKey) {
        byte[] token = jwt.getString("access_token").getBytes(Values.CHARSET);
        byte[] refreshToken = jwt.getString("refresh_token").getBytes(Values.CHARSET);
        Long iat = jwt.getLong("iat");
        return new OAccessToken().setKey(UUID.randomUUID().toString()).setAuth(userKey.getBytes(Values.CHARSET)).setCreatedBy(userKey).setCreatedAt(LocalDateTime.now()).setToken(token).setRefreshToken(refreshToken).setExpiredTime(iat).setActive(Boolean.TRUE);
    }
}

