/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.service.business;

import cn.vertxup.domain.tables.daos.RGroupRoleDao;
import cn.vertxup.domain.tables.daos.SGroupDao;
import cn.vertxup.domain.tables.pojos.SGroup;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.tp.rbac.service.business.GroupStub;
import io.vertx.up.aiki.Uarr;
import io.vertx.up.aiki.Ux;
import io.vertx.up.aiki.UxJooq;
import io.vertx.up.log.Annal;
import java.util.ArrayList;
import java.util.List;

public class GroupService
implements GroupStub {
    private static final Annal LOGGER = Annal.get(GroupService.class);

    @Override
    public Future<JsonArray> fetchRoleIdsAsync(String groupKey) {
        Sc.infoAuth(LOGGER, "Fetch relation ( Group - Role ) by Group key: {0}, Mode: {1}", groupKey, "Async");
        return Sc.relation("groupId", groupKey, RGroupRoleDao.class);
    }

    @Override
    public JsonArray fetchRoleIds(String groupKey) {
        Sc.infoAuth(LOGGER, "Fetch relation ( Group - Role ) by Group key: {0}, Mode: {1}", groupKey, "Sync");
        List relations = Ux.Jooq.on(RGroupRoleDao.class).fetch("groupId", (Object)groupKey);
        return Uarr.create((JsonArray)Ux.toArray((List)relations)).remove(new String[]{"groupId"}).to();
    }

    @Override
    public SGroup fetchParent(String groupKey) {
        UxJooq dao = Ux.Jooq.on(SGroupDao.class);
        if (null == dao) {
            return null;
        }
        SGroup current = (SGroup)dao.findById((Object)groupKey);
        return null == current ? null : (SGroup)dao.findById((Object)current.getParentId());
    }

    @Override
    public List<SGroup> fetchChildren(String groupKey) {
        UxJooq dao = Ux.Jooq.on(SGroupDao.class);
        if (null == dao) {
            return new ArrayList<SGroup>();
        }
        return dao.fetch("parentId", (Object)groupKey);
    }
}

