/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.service.business;

import cn.vertxup.domain.tables.daos.OUserDao;
import cn.vertxup.domain.tables.daos.RUserGroupDao;
import cn.vertxup.domain.tables.daos.RUserRoleDao;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.tp.rbac.service.business.UserStub;
import io.vertx.up.aiki.Ux;
import io.vertx.up.log.Annal;

public class UserService
implements UserStub {
    private static final Annal LOGGER = Annal.get(UserService.class);

    @Override
    public Future<JsonObject> fetchOUser(String userKey) {
        return Ux.Jooq.on(OUserDao.class).fetchOneAsync("clientId", (Object)userKey).compose(Ux::fnJObject);
    }

    @Override
    public Future<JsonArray> fetchRoleIds(String userKey) {
        Sc.infoAuth(LOGGER, "Fetch relations ( User - Role ) by User key: {0}", userKey);
        return Sc.relation("userId", userKey, RUserRoleDao.class);
    }

    @Override
    public Future<JsonArray> fetchGroupIds(String userKey) {
        Sc.infoAuth(LOGGER, "Fetch relations ( User - Group ) by User key: {0}", userKey);
        return Sc.relation("userId", userKey, RUserGroupDao.class);
    }
}

