/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.service.login;

import cn.vertxup.domain.tables.daos.OUserDao;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._401CodeGenerationException;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.tp.rbac.service.login.AuthStub;
import io.vertx.tp.rbac.service.login.CodeStub;
import io.vertx.tp.rbac.service.login.LoginStub;
import io.vertx.tp.rbac.service.login.TokenStub;
import io.vertx.up.aiki.Ux;
import io.vertx.up.log.Annal;
import io.vertx.up.secure.Security;
import io.zero.epic.fn.Fn;
import io.zero.epic.fn.wait.Case;
import javax.inject.Inject;

public class AuthService
implements AuthStub {
    private static final Annal LOGGER = Annal.get(AuthService.class);
    @Inject
    private transient CodeStub codeStub;
    @Inject
    private transient LoginStub loginStub;
    @Inject
    private transient TokenStub tokenStub;
    @Inject
    private transient Security security;

    @Override
    public Future<JsonObject> authorize(JsonObject filters, String state) {
        Sc.infoAuth(LOGGER, "Authorization Code Filters: {0}", filters.encode());
        return Ux.Jooq.on(OUserDao.class).fetchOneAndAsync(filters).compose(item -> Fn.match(() -> Fn.fork(() -> this.codeStub.authorize(item.getClientId(), state)), (Case[])new Case[]{Fn.branch((null == item ? 1 : 0) != 0, () -> Ux.thenError(_401CodeGenerationException.class, (Object[])new Object[]{this.getClass(), filters.getString("clientId"), filters.getString("clientSecret")}))}));
    }

    @Override
    public Future<JsonObject> token(JsonObject params, String state) {
        String code = params.getString("code");
        String clientId = params.getString("client_id");
        Sc.infoAuth(LOGGER, "Input data when verification: client_id = {0}, code = {1}", clientId, code);
        return this.tokenStub.execute(clientId, code, state).compose(arg_0 -> ((Security)this.security).store(arg_0));
    }

    @Override
    public Future<JsonObject> login(JsonObject params) {
        String username = params.getString("username");
        String password = params.getString("password");
        Sc.infoAuth(LOGGER, "Login processing execute ( username = {0} )", username);
        return this.loginStub.execute(username, password);
    }
}

