/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.service.login;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.atom.ScConfig;
import io.vertx.tp.rbac.init.ScPin;
import io.vertx.tp.rbac.service.business.GroupStub;
import io.vertx.tp.rbac.service.business.UserStub;
import io.vertx.tp.rbac.service.login.CodeStub;
import io.vertx.tp.rbac.service.login.TokenStub;
import io.vertx.up.aiki.Uson;
import io.vertx.up.aiki.Ux;
import java.util.ArrayList;
import java.util.Objects;
import javax.inject.Inject;

public class TokenService
implements TokenStub {
    @Inject
    private transient CodeStub codeStub;
    @Inject
    private transient UserStub userStub;
    @Inject
    private transient GroupStub groupStub;

    @Override
    public Future<JsonObject> execute(String clientId, String code, String state) {
        return this.codeStub.verify(clientId, code).compose(item -> this.userStub.fetchRoleIds((String)item)).compose(roles -> Uson.create().append("user", (Object)clientId).append("role", roles).toFuture()).compose(this::fetchGroup);
    }

    private Future<JsonObject> fetchGroup(JsonObject response) {
        ScConfig config = ScPin.getConfig();
        if (config.getSupportGroup().booleanValue()) {
            String userKey = response.getString("user");
            return this.userStub.fetchGroupIds(userKey).compose(this::fetchRoles).compose(groups -> Uson.create((JsonObject)response).append("group", groups).toFuture());
        }
        return Future.succeededFuture((Object)response);
    }

    private Future<JsonArray> fetchRoles(JsonArray groups) {
        ArrayList futures = new ArrayList();
        groups.stream().filter(Objects::nonNull).map(item -> (JsonObject)item).forEach(item -> futures.add(this.groupStub.fetchRoleIdsAsync(item.getString("groupId")).compose(roles -> Uson.create((JsonObject)item).append("role", roles).toFuture())));
        return Ux.thenComposite(futures);
    }
}

