/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.atom;

import io.vertx.core.Future;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.rbac.atom.ScConfig;
import io.vertx.tp.rbac.init.ScPin;
import io.vertx.tp.rbac.permission.ScPrivilege;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import java.io.Serializable;

public class ScRequest
implements Serializable {
    private static final ScConfig CONFIG = ScPin.getConfig();
    private static final Annal LOGGER = Annal.get(ScRequest.class);
    private final transient String uri;
    private final transient String requestUri;
    private final transient String sigma;
    private final transient String user;
    private final transient String sessionId;
    private final transient String view = "DEFAULT";
    private final transient HttpMethod method;

    public ScRequest(JsonObject data) {
        JsonObject metadata = data.getJsonObject("metadata");
        String uri = metadata.getString("uri");
        this.requestUri = metadata.getString("requestUri");
        this.method = HttpMethod.valueOf((String)metadata.getString("method"));
        this.uri = Sc.uri(uri, this.requestUri);
        if (CONFIG.getSupportMultiApp().booleanValue()) {
            JsonObject headers = data.getJsonObject("headers");
            this.sigma = headers.getString("X-Sigma");
        } else {
            this.sigma = null;
        }
        String token = data.getString("jwt");
        JsonObject userData = Ux.Jwt.extract((String)token);
        this.user = userData.getString("user");
        this.sessionId = userData.getString("habitus");
    }

    public String getNormalizedUri() {
        return this.uri;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getSigma() {
        return this.sigma;
    }

    public String getUser() {
        return this.user;
    }

    public String getView() {
        return this.view;
    }

    public String getCacheKey() {
        return Ke.keySession((String)this.method.name(), (String)this.uri);
    }

    public String getAuthorizedKey() {
        return Ke.keyAuthorized((String)this.method.name(), (String)this.uri);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Future<ScPrivilege> openSession() {
        LOGGER.debug("Open session: {0}", new Object[]{this.sessionId});
        return ScPrivilege.open(this.sessionId);
    }
}

