/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.extension;

import io.vertx.core.Future;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.tp.rbac.extension.DataMin;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.commune.Envelop;
import io.vertx.up.extension.region.AbstractRegion;
import io.vertx.up.unity.Ux;
import java.util.Objects;

public class DataRegion
extends AbstractRegion {
    public Future<Envelop> before(RoutingContext context, Envelop envelop) {
        if (this.isEnabled(context)) {
            return Sc.cacheBound(context, envelop).compose(matrix -> {
                if (Objects.nonNull(matrix)) {
                    Sc.infoAuth(this.getLogger(), context.request().path(), "--> DataRegion Before: uri = {0}, region = {1}git", matrix.encode());
                    HttpMethod method = envelop.getMethod();
                    if (HttpMethod.POST == method || HttpMethod.PUT == method) {
                        JsonObject criteria;
                        JsonArray projection = matrix.getJsonArray("projection");
                        if (Objects.nonNull(projection) && !projection.isEmpty()) {
                            envelop.onProjection(projection);
                        }
                        if (Objects.nonNull(criteria = matrix.getJsonObject("criteria")) && !criteria.isEmpty()) {
                            envelop.onCriteria(criteria);
                        }
                    }
                }
                return Ux.future((Object)envelop);
            });
        }
        return Ux.future((Object)envelop);
    }

    public Future<Envelop> after(RoutingContext context, Envelop response) {
        if (this.isEnabled(context)) {
            return Sc.cacheBound(context, response).compose(matrix -> {
                Sc.infoAuth(this.getLogger(), "<-- DataRegion After: {0}", matrix.encode());
                DataMin.dwarfRecord(response, matrix);
                DataMin.dwarfRows(response, matrix);
                DataMin.dwarfCollection(response, matrix);
                return Ux.future((Object)response);
            });
        }
        return Ux.future((Object)response);
    }
}

