package cn.vertxup.rbac.service.business;

import cn.vertxup.rbac.domain.tables.daos.RRolePermDao;
import cn.vertxup.rbac.domain.tables.pojos.RRolePerm;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.cv.KeField;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;

import java.util.List;
import java.util.stream.Collectors;

public class RoleService implements RoleStub {
    @Override
    public Future<JsonArray> updateRolePerm(String roleId, JsonArray data) {
        // 1. make up role-perm entity
        final List<RRolePerm> rolePerms = Ut.itJString(data)
                .filter(Ut::notNil)
                .map(perm -> new JsonObject().put(KeField.Rbac.PERM_ID, perm).put(KeField.Rbac.ROLE_ID, roleId))
                .map(rolePerm -> Ux.fromJson(rolePerm, RRolePerm.class))
                .collect(Collectors.toList());
        // 2. delete old ones and insert new ones
        return this.deleteByRoleId(roleId)
                .compose(result -> Ux.Jooq.on(RRolePermDao.class)
                        .insertAsync(rolePerms)
                        .compose(Ux::fnJArray)
                );
    }

    @Override
    public Future<Boolean> deleteByRoleId(String roleId) {
        return Ux.Jooq.on(RRolePermDao.class)
                .deleteAsync(new JsonObject().put(KeField.Rbac.ROLE_ID, roleId));
    }
}
