/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.api;

import cn.vertxup.rbac.domain.tables.daos.RRolePermDao;
import cn.vertxup.rbac.domain.tables.pojos.RRolePerm;
import cn.vertxup.rbac.service.business.PermStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Queue;
import io.vertx.up.commune.config.XHeader;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.unity.jq.UxJooq;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import javax.inject.Inject;

@Queue
public class PermActor {
    @Inject
    private transient PermStub stub;

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-PERMISSION/GROUP")
    public Future<JsonArray> calculate(XHeader header) {
        return this.stub.groupAsync(header.getSigma());
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-PERMISSION/DEFINITION/SAVING")
    public Future<JsonObject> saveDefinition(JsonObject processed, XHeader header) {
        String sigma = header.getSigma();
        Sc.infoWeb(this.getClass(), "Permission Update: {0}, sigma = {1}", processed.encode(), sigma);
        JsonArray permissions = Ut.sureJArray((JsonArray)processed.getJsonArray("data"));
        String group = processed.getString("group");
        JsonArray removed = Ut.sureJArray((JsonArray)processed.getJsonArray("removed"));
        JsonObject relation = Ut.sureJObject((JsonObject)processed.getJsonObject("relation"));
        return this.stub.syncPerm(permissions, group, sigma).compose(nil -> this.stub.savingPerm(removed, relation)).compose(nil -> Ux.future((Object)relation));
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-PERMISSION/BY/ROLE")
    public Future<JsonArray> fetchAsync(String roleId) {
        return (Future)Fn.getEmpty((Object)Ux.futureJArray(), () -> Ux.Jooq.on(RRolePermDao.class).fetchAsync("roleId", (Object)roleId).compose(Ux::fnJArray), (String[])new String[]{roleId});
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-PERMISSION/SAVING")
    public Future<JsonArray> savePerm(String roleId, JsonArray permissions) {
        return (Future)Fn.getEmpty((Object)Ux.futureJArray(), () -> {
            JsonObject condition = new JsonObject();
            condition.put("roleId", roleId);
            UxJooq dao = Ux.Jooq.on(RRolePermDao.class);
            return dao.deleteAsync(condition).compose(processed -> {
                ArrayList relations = new ArrayList();
                Ut.itJArray((JsonArray)permissions, String.class, (permissionId, index) -> {
                    RRolePerm item = new RRolePerm();
                    item.setRoleId(roleId);
                    item.setPermId((String)permissionId);
                    relations.add(item);
                });
                return dao.insertAsync(relations).compose(inserted -> Sc.cachePermission(roleId, permissions).compose(nil -> Ux.future((Object)inserted))).compose(Ux::fnJArray);
            });
        }, (String[])new String[]{roleId});
    }
}

