/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.accredit;

import cn.vertxup.rbac.domain.tables.pojos.SAction;
import cn.vertxup.rbac.domain.tables.pojos.SResource;
import cn.vertxup.rbac.service.accredit.AccreditFlow;
import cn.vertxup.rbac.service.accredit.AccreditStub;
import cn.vertxup.rbac.service.accredit.ActionStub;
import cn.vertxup.rbac.service.accredit.MatrixStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.atom.ScRequest;
import io.vertx.up.atom.Refer;
import io.vertx.up.unity.Ux;
import java.util.function.Supplier;
import javax.inject.Inject;

public class AccreditService
implements AccreditStub {
    @Inject
    private transient ActionStub actionStub;
    @Inject
    private transient MatrixStub matrixStub;

    @Override
    public Future<Boolean> authorize(JsonObject data) {
        ScRequest request = new ScRequest(data);
        Refer actionHod = new Refer();
        Refer resourceHod = new Refer();
        return this.authorizedWithCache(request, () -> this.actionStub.fetchAction(request.getNormalizedUri(), request.getMethod(), request.getSigma()).compose(action -> AccreditFlow.inspectAction(this.getClass(), action, request)).compose(arg_0 -> ((Refer)actionHod).future(arg_0)).compose(action -> this.actionStub.fetchResource(action.getResourceId())).compose(resource -> AccreditFlow.inspectResource(this.getClass(), resource, request, (SAction)actionHod.get())).compose(resource -> AccreditFlow.inspectLevel(this.getClass(), resource, (SAction)actionHod.get())).compose(arg_0 -> ((Refer)resourceHod).future(arg_0)).compose(resource -> AccreditFlow.inspectPermission(this.getClass(), resource, request)).compose(permissions -> AccreditFlow.inspectAuthorized(this.getClass(), (SAction)actionHod.get(), permissions)).compose(result -> this.authorized((Boolean)result, request, (SResource)resourceHod.get(), (SAction)actionHod.get())));
    }

    private Future<Boolean> authorizedWithCache(ScRequest request, Supplier<Future<Boolean>> supplier) {
        String authorizedKey = request.getAuthorizedKey();
        return request.openSession().compose(privilege -> privilege.fetchAuthorized(authorizedKey)).compose(result -> result != false ? Ux.future((Object)Boolean.TRUE) : (Future)supplier.get());
    }

    private Future<Boolean> authorized(Boolean result, ScRequest request, SResource resource, SAction action) {
        if (result.booleanValue()) {
            return this.matrixStub.fetchBound(request, resource).compose(bound -> Ux.future((Object)bound.addCredit(action.getRenewalCredit()))).compose(bound -> AccreditFlow.inspectBound(bound, request)).compose(nil -> AccreditFlow.inspectAuthorized(request));
        }
        return Future.succeededFuture((Object)Boolean.FALSE);
    }
}

