/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic;

import cn.vertxup.rbac.service.view.ViewService;
import cn.vertxup.rbac.service.view.ViewStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.optic.ApeakMy;
import io.vertx.tp.optic.fantom.Anchoret;
import io.vertx.tp.rbac.permission.ScHabitus;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.function.Function;

public class ExColumnApeakMy
extends Anchoret<ApeakMy>
implements ApeakMy {
    private final transient ViewStub stub = (ViewStub)Ut.singleton(ViewService.class, (Object[])new Object[0]);

    public Future<JsonArray> fetchMy(JsonObject params) {
        String userId = params.getString("user");
        String view = params.getString("view");
        return this.uniform(params, resourceId -> this.stub.fetchMatrix(userId, (String)resourceId, view).compose(queried -> Objects.isNull(queried) ? Ux.future((Object)new JsonArray()) : Ux.future((Object)Ut.toJArray((String)queried.getProjection()))));
    }

    public Future<JsonArray> saveMy(JsonObject params, JsonArray projection) {
        String userId = params.getString("user");
        String view = params.getString("view");
        return this.uniform(params, resourceId -> this.stub.saveMatrix(userId, (String)resourceId, view, projection).compose(updated -> Ux.future((Object)Ut.toJArray((String)updated.getProjection())))).compose(flushed -> this.flush(params, (JsonArray)flushed));
    }

    private Future<JsonArray> flush(JsonObject params, JsonArray updated) {
        String habitus = params.getString("habitus");
        ScHabitus habit = ScHabitus.initialize(habitus);
        String dataKey = params.getString("dataKey");
        return habit.get(dataKey).compose(stored -> {
            if (Objects.isNull(stored)) {
                return Ux.future((Object)updated);
            }
            JsonObject updatedJson = stored.copy();
            updatedJson.put("projection", updated);
            return habit.set(dataKey, updatedJson).compose(retured -> {
                Sc.infoAuth(this.getLogger(), "DataRegion Flush -> habitus = {0}, dataKey = {1}, From \n{2} \nto \n{3}", habitus, dataKey, stored.encodePrettily(), retured.encodePrettily());
                return Ux.future((Object)updated);
            });
        });
    }

    private Future<JsonArray> uniform(JsonObject params, Function<String, Future<JsonArray>> function) {
        String resourceId = params.getString("resourceId");
        if (Ut.isNil((String)resourceId)) {
            return Ux.future((Object)new JsonArray());
        }
        return function.apply(resourceId);
    }
}

