/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.acl.region;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.acl.region.Cosmo;
import io.vertx.tp.rbac.acl.region.DataAcl;
import io.vertx.tp.rbac.acl.region.DataIn;
import io.vertx.tp.rbac.acl.region.DataOut;
import io.vertx.tp.rbac.cv.em.AclTime;
import io.vertx.up.commune.Envelop;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;

public class SeekCosmo
implements Cosmo {
    @Override
    public Future<Envelop> before(Envelop request, JsonObject matrix) {
        JsonObject seeker = matrix.getJsonObject("seeker");
        String component = seeker.getString("component");
        if (Ut.notNil((String)component)) {
            Cosmo external = (Cosmo)Ut.singleton((String)component, (Object[])new Object[0]);
            return external.before(request, matrix);
        }
        if (Ut.isNil((JsonObject)seeker)) {
            DataIn.visitProjection(request, matrix);
            DataIn.visitCriteria(request, matrix);
            return Ux.future((Object)request);
        }
        return DataAcl.visitAcl(request, matrix, AclTime.BEFORE).compose(acl -> {
            request.acl(acl);
            DataIn.visitProjection(request, matrix);
            DataIn.visitCriteria(request, matrix);
            return Ux.future((Object)request);
        });
    }

    @Override
    public Future<Envelop> after(Envelop response, JsonObject matrix) {
        JsonObject seeker = matrix.getJsonObject("seeker");
        String component = seeker.getString("component");
        if (Ut.notNil((String)component)) {
            Cosmo external = (Cosmo)Ut.singleton((String)component, (Object[])new Object[0]);
            return external.after(response, matrix);
        }
        return DataAcl.visitAcl(response, matrix, AclTime.AFTER).compose(acl -> {
            response.acl(acl);
            DataOut.dwarfRecord(response, matrix);
            DataOut.dwarfRows(response, matrix);
            DataOut.dwarfCollection(response, matrix);
            if (Objects.nonNull(acl)) {
                response.attach("acl", (Object)acl.acl());
            }
            return Ux.future((Object)response);
        }).otherwise(Ux.otherwise());
    }
}

