/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.api;

import cn.vertxup.rbac.service.business.UserStub;
import cn.vertxup.rbac.service.login.LoginStub;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.optic.Trash;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Queue;
import io.vertx.up.commune.Envelop;
import io.vertx.up.unity.Ux;
import java.util.Objects;
import javax.inject.Inject;

@Queue
public class UserActor {
    @Inject
    private transient UserStub stub;
    @Inject
    private transient LoginStub loginStub;

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-INFORMATION")
    public Future<JsonObject> information(Envelop envelop) {
        String userId = envelop.jwt("user");
        return this.stub.fetchEmployee(userId);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-PASSWORD")
    public Future<JsonObject> password(Envelop envelop) {
        String userId = envelop.jwt("user");
        JsonObject params = Ux.getJson((Envelop)envelop);
        return this.stub.updateUser(userId, params);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-PROFILE")
    public Future<JsonObject> profile(Envelop envelop) {
        String userId = envelop.jwt("user");
        JsonObject params = Ux.getJson((Envelop)envelop);
        return this.stub.updateEmployee(userId, params);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/O-LOGOUT")
    public Future<Boolean> logout(Envelop envelop) {
        String token = envelop.jwt();
        String habitus = envelop.jwt("habitus");
        return this.loginStub.logout(token, habitus).compose(result -> {
            RoutingContext context = envelop.context();
            context.clearUser();
            Session session = context.session();
            if (Objects.nonNull(session) && !session.isDestroyed()) {
                session.destroy();
            }
            Vertx vertx = context.vertx();
            Promise logout = Promise.promise();
            vertx.sharedData().getAsyncMap("JWT_AUTH_TOKEN_POOL", res -> {
                if (res.succeeded()) {
                    ((AsyncMap)res.result()).remove((Object)token, handler -> logout.complete(handler.result()));
                } else {
                    logout.complete((Object)Boolean.FALSE);
                }
            });
            return logout.future();
        });
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-USER/GET/ID")
    public Future<JsonObject> getById(String key) {
        return this.stub.fetchUser(key);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-USER/ADD")
    public Future<JsonObject> create(JsonObject data) {
        return this.stub.createUser(data);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-PUT/USER/ID")
    public Future<JsonObject> update(String key, JsonObject data) {
        return this.stub.updateUser(key, data);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-DELETE/USER/ID")
    public Future<Boolean> delete(String key) {
        return Ke.channelAsync(Trash.class, () -> this.stub.deleteUser(key), tunnel -> this.stub.fetchUser(key).compose(user -> tunnel.backupAsync("sec.user", user)).compose(backup -> this.stub.deleteUser(key)));
    }
}

