/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.business;

import cn.vertxup.rbac.domain.tables.daos.OUserDao;
import cn.vertxup.rbac.domain.tables.daos.RUserGroupDao;
import cn.vertxup.rbac.domain.tables.daos.RUserRoleDao;
import cn.vertxup.rbac.domain.tables.daos.SUserDao;
import cn.vertxup.rbac.domain.tables.pojos.OUser;
import cn.vertxup.rbac.domain.tables.pojos.RUserGroup;
import cn.vertxup.rbac.domain.tables.pojos.RUserRole;
import cn.vertxup.rbac.domain.tables.pojos.SUser;
import cn.vertxup.rbac.service.business.UserHelper;
import cn.vertxup.rbac.service.business.UserStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class UserService
implements UserStub {
    private static final Annal LOGGER = Annal.get(UserService.class);

    @Override
    public Future<JsonObject> fetchOUser(String userKey) {
        return Ux.Jooq.on(OUserDao.class).fetchOneAsync("clientId", (Object)userKey).compose(Ux::futureJ);
    }

    @Override
    public Future<JsonArray> fetchRoleIds(String userKey) {
        Sc.infoAuth(LOGGER, "Fetch relations ( User - Role ) by User key: {0}", userKey);
        return Sc.relation("userId", userKey, RUserRoleDao.class);
    }

    @Override
    public Future<JsonArray> fetchGroupIds(String userKey) {
        Sc.infoAuth(LOGGER, "Fetch relations ( User - Group ) by User key: {0}", userKey);
        return Sc.relation("userId", userKey, RUserGroupDao.class);
    }

    @Override
    public Future<JsonObject> fetchEmployee(String userId) {
        return Ux.Jooq.on(SUserDao.class).fetchByIdAsync((Object)userId).compose(UserHelper::fetchEmployee);
    }

    @Override
    public Future<JsonObject> updateUser(String userId, JsonObject params) {
        JsonArray roles = params.getJsonArray("roles");
        JsonArray groups = params.getJsonArray("groups");
        SUser user = (SUser)Ux.fromJson((JsonObject)params, SUser.class);
        user.setKey(userId);
        return Ux.Jooq.on(SUserDao.class).updateAsync((Object)userId, (Object)user).compose(entity -> this.updateRoles(userId, Ux.toJson((Object)entity), roles)).compose(entity -> this.updateGroups(userId, Ux.toJson((Object)entity), groups));
    }

    @Override
    public Future<JsonObject> updateEmployee(String userId, JsonObject params) {
        SUser user = (SUser)Ux.fromJson((JsonObject)params, SUser.class);
        user.setKey(userId);
        return Ux.Jooq.on(SUserDao.class).updateAsync((Object)userId, (Object)user).compose(userInfo -> UserHelper.updateEmployee(userInfo, params));
    }

    @Override
    public Future<JsonObject> fetchUser(String userKey) {
        return Ux.Jooq.on(SUserDao.class).fetchByIdAsync((Object)userKey).compose(userInfo -> this.fulfillUserWithRolesAndGroups(userKey, Ux.toJson((Object)userInfo)));
    }

    @Override
    public Future<JsonObject> createUser(JsonObject params) {
        SUser user = (SUser)Ux.fromJson((JsonObject)params, SUser.class);
        if (Objects.isNull(user.getPassword())) {
            user.setPassword(Sc.generatePwd());
        }
        return Ux.Jooq.on(SUserDao.class).insertAsync((Object)user).compose(this::createOUser);
    }

    @Override
    public Future<Boolean> deleteUser(String userKey) {
        UxJooq sUserDao = Ux.Jooq.on(SUserDao.class);
        UxJooq oUserDao = Ux.Jooq.on(OUserDao.class);
        UxJooq rUserRoleDao = Ux.Jooq.on(RUserRoleDao.class);
        UxJooq rUserGroupDao = Ux.Jooq.on(RUserGroupDao.class);
        return oUserDao.fetchOneAsync(new JsonObject().put("CLIENT_ID", userKey)).compose(item -> oUserDao.deleteByIdAsync((Object)Ux.toJson((Object)item).getString("key"))).compose(oUserFlag -> rUserRoleDao.deleteByAsync(new JsonObject().put("USER_ID", userKey))).compose(rUserRoleFlag -> rUserGroupDao.deleteByAsync(new JsonObject().put("USER_ID", userKey))).compose(rUserGroupFlag -> sUserDao.deleteByIdAsync((Object)userKey));
    }

    private Future<JsonObject> createOUser(SUser user) {
        OUser oUser = new OUser().setClientId(user.getKey()).setClientSecret(Ut.randomString((int)64)).setScope("vie.app.ox").setGrantType("authorization_code").setLanguage("cn").setActive(Boolean.TRUE).setKey(UUID.randomUUID().toString());
        return Ux.Jooq.on(OUserDao.class).insertAsync((Object)oUser).compose(entity -> Ux.futureJ((Object)user.setPassword("")));
    }

    private Future<JsonObject> fulfillUserWithRolesAndGroups(String userKey, JsonObject user) {
        user.put("password", "").put("roles", Ux.Jooq.on(RUserRoleDao.class).fetch("userId", (Object)userKey).stream().sorted(Comparator.comparing(item -> ((RUserRole)item).getPriority())).map(item -> Ux.toJson((Object)item).getString("roleId")).collect(Collectors.toList())).put("groups", Ux.Jooq.on(RUserGroupDao.class).fetch("userId", (Object)userKey).stream().sorted(Comparator.comparing(item -> ((RUserGroup)item).getPriority())).map(item -> Ux.toJson((Object)item).getString("groupId")).collect(Collectors.toList()));
        return Ux.future((Object)user);
    }

    private Future<JsonObject> updateRoles(String userKey, JsonObject user, JsonArray roles) {
        if (Objects.isNull(roles)) {
            return Ux.future((Object)user);
        }
        List roleIds = roles.getList();
        return Ux.Jooq.on(RUserRoleDao.class).deleteByAsync(new JsonObject().put("userId", userKey)).compose(roleFlag -> Ux.future(roleIds.stream().map(roleId -> {
            RUserRole rUserRole = new RUserRole().setUserId(userKey).setRoleId((String)roleId).setPriority(roleIds.indexOf(roleId));
            return (RUserRole)Ux.Jooq.on(RUserRoleDao.class).insert((Object)rUserRole);
        }).collect(Collectors.toList())).compose(inserted -> Ux.future((Object)user.put("roles", roles))));
    }

    private Future<JsonObject> updateGroups(String userKey, JsonObject user, JsonArray groups) {
        if (Objects.isNull(groups)) {
            return Ux.future((Object)user);
        }
        List groupIds = groups.getList();
        return Ux.Jooq.on(RUserGroupDao.class).deleteByAsync(new JsonObject().put("userId", userKey)).compose(groupFlag -> Ux.future(groupIds.stream().map(groupId -> {
            RUserGroup rUserGroup = new RUserGroup().setUserId(userKey).setGroupId((String)groupId).setPriority(groupIds.indexOf(groupId));
            return (RUserGroup)Ux.Jooq.on(RUserGroupDao.class).insert((Object)rUserGroup);
        }).collect(Collectors.toList()))).compose(inserted -> Ux.future((Object)user.put("groups", groups)));
    }
}

