/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.acl.region;

import cn.vertxup.rbac.domain.tables.daos.SVisitantDao;
import cn.vertxup.rbac.domain.tables.pojos.SVisitant;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.atom.acl.AclData;
import io.vertx.tp.rbac.cv.em.AclTime;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.commune.Envelop;
import io.vertx.up.commune.secure.Acl;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;

class DataAcl {
    private static final Annal LOGGER = Annal.get(DataAcl.class);

    DataAcl() {
    }

    static Future<Acl> visitAcl(Envelop envelop, JsonObject matrix, AclTime expected) {
        JsonObject seeker = matrix.getJsonObject("seeker");
        JsonObject syntax = seeker.getJsonObject("syntax");
        AclTime actual = (AclTime)Ut.toEnum(() -> syntax.getString("phase"), AclTime.class, (Enum)AclTime.BEFORE);
        if (expected == actual) {
            JsonObject input = new JsonObject();
            JsonObject viewData = matrix.getJsonObject("view");
            JsonObject data = envelop.body();
            input.mergeIn(data, true);
            input.put("resourceId", viewData.getString("resourceId"));
            input.put("sigma", viewData.getString("sigma"));
            input.put("language", viewData.getString("language"));
            input.put("viewId", viewData.getString("key"));
            JsonObject condition = new JsonObject();
            JsonObject syntaxData = Ut.sureJObject((JsonObject)syntax.getJsonObject("data"));
            Ut.itJObject((JsonObject)syntaxData, (expr, field) -> {
                String literal = expr.contains("`") ? Ut.fromExpression((String)expr, (JsonObject)input) : expr;
                if (Ut.notNil((String)literal)) {
                    condition.put(field, literal);
                }
            });
            Sc.infoView(DataAcl.class, "Visitant unique query condition: {0}", condition);
            if (Ut.notNil((JsonObject)condition)) {
                return Ux.Jooq.on(SVisitantDao.class).fetchAndAsync(condition).compose(visitant -> {
                    SVisitant ret = 0 < visitant.size() ? (SVisitant)visitant.get(0) : null;
                    if (Objects.isNull(ret)) {
                        return Ux.future();
                    }
                    return Ux.future((Object)new AclData(ret).config(syntax.getJsonObject("config")));
                });
            }
            return Ux.future();
        }
        return Ux.future((Object)envelop.acl());
    }
}

