/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.refine;

import io.vertx.core.Future;
import io.vertx.tp.rbac.atom.ScConfig;
import io.vertx.tp.rbac.init.ScPin;
import io.vertx.up.unity.Ux;

class ScCache {
    private static final ScConfig CONFIG = ScPin.getConfig();

    ScCache() {
    }

    static <V> Future<V> code(String key) {
        String codePool = CONFIG.getCodePool();
        return Ux.Pool.on((String)codePool).remove((Object)key).compose(value -> Ux.future((Object)value.getValue()));
    }

    static <V> Future<V> code(String key, V value) {
        String codePool = CONFIG.getCodePool();
        Integer codeExpired = CONFIG.getCodeExpired();
        return Ux.Pool.on((String)codePool).put((Object)key, value, codeExpired.intValue()).compose(item -> Ux.future((Object)item.getValue()));
    }

    static <V> Future<V> permission(String key) {
        String permissionPool = CONFIG.getPermissionPool();
        return Ux.Pool.on((String)permissionPool).get((Object)key);
    }

    static <V> Future<V> permission(String key, V value) {
        String permissionPool = CONFIG.getPermissionPool();
        return Ux.Pool.on((String)permissionPool).put((Object)key, value).compose(item -> Ux.future((Object)item.getValue()));
    }

    static <V> Future<V> permissionClear(String key) {
        String permissionPool = CONFIG.getPermissionPool();
        return Ux.Pool.on((String)permissionPool).remove((Object)key).compose(item -> Ux.future((Object)item.getValue()));
    }
}

