/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.refine;

import cn.vertxup.rbac.domain.tables.pojos.SResource;
import io.vertx.tp.rbac.atom.ScConfig;
import io.vertx.tp.rbac.init.ScPin;
import io.vertx.tp.rbac.refine.ScLog;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.util.Locale;

class ScTool {
    private static final Annal LOGGER = Annal.get(ScTool.class);
    private static final ScConfig CONFIG = ScPin.getConfig();

    ScTool() {
    }

    static String generateCode() {
        Integer codeLength = CONFIG.getCodeLength();
        String authCode = Ut.randomString((int)codeLength);
        ScLog.infoAuth(LOGGER, "Generated Authorization Code: {0}", authCode);
        return authCode;
    }

    static String generatePwd() {
        return CONFIG.getPasswordInit();
    }

    static String generateProfileKey(SResource resource) {
        String modeRole = resource.getModeRole();
        String modeGroup = resource.getModeGroup();
        if (Ut.isNil((String)modeGroup)) {
            return "USER_" + modeRole.toUpperCase(Locale.getDefault());
        }
        String modeTree = resource.getModeTree();
        String group = modeGroup.toUpperCase(Locale.getDefault()) + "_" + modeRole.toUpperCase(Locale.getDefault());
        if (Ut.isNil((String)modeTree)) {
            return group;
        }
        return modeTree.toUpperCase(Locale.getDefault()) + "_" + group;
    }
}

