package io.vertx.tp.rbac.authorization.detent;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.atom.ProfileGroup;
import io.vertx.tp.rbac.atom.ProfileRole;
import io.vertx.tp.rbac.authorization.ScDetent;

import java.util.List;

public class ScDetentChild implements ScDetent {

    private transient final JsonObject input;
    private transient final List<ProfileGroup> original;

    public ScDetentChild(final JsonObject input,
                         final List<ProfileGroup> original) {
        this.input = input;
        this.original = original;
    }

    @Override
    public JsonObject proc(final List<ProfileRole> profiles) {
        final JsonObject children = new JsonObject();
        /* SeekGroup -> Parent Horizon */

        children.mergeIn(ScDetent.Group.Child.horizon().proc(profiles));
        /* SeekGroup -> Parent Critical */
        children.mergeIn(ScDetent.Group.Child.critical(this.original).proc(profiles));
        /* SeekGroup -> Parent Priority */
        children.mergeIn(ScDetent.Group.Child.overlook(this.original).proc(profiles));
        return this.input.mergeIn(children);
    }
}
