/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.business;

import cn.vertxup.rbac.domain.tables.daos.RRolePermDao;
import cn.vertxup.rbac.domain.tables.daos.SActionDao;
import cn.vertxup.rbac.domain.tables.daos.SPermSetDao;
import cn.vertxup.rbac.domain.tables.daos.SPermissionDao;
import cn.vertxup.rbac.domain.tables.pojos.RRolePerm;
import cn.vertxup.rbac.domain.tables.pojos.SPermSet;
import cn.vertxup.rbac.domain.tables.pojos.SPermission;
import cn.vertxup.rbac.service.accredit.ActionStub;
import cn.vertxup.rbac.service.business.PermStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class PermService
implements PermStub {
    @Inject
    private transient ActionStub actionStub;

    @Override
    public Future<JsonObject> syncAsync(JsonArray removed, JsonObject relation, String userKey) {
        ArrayList entities = new ArrayList();
        UxJooq jooq = Ux.Jooq.on(SActionDao.class);
        Ut.itJString((JsonArray)removed).map(key -> jooq.fetchByIdAsync(key).compose(action -> {
            action.setPermissionId(null);
            action.setUpdatedBy(userKey);
            action.setUpdatedAt(LocalDateTime.now());
            return Ux.future((Object)action);
        }).compose(arg_0 -> ((UxJooq)jooq).updateAsync(arg_0))).forEach(entities::add);
        return Ux.thenCombineT(entities).compose(actions -> {
            ArrayList actionList = new ArrayList();
            Ut.itJObject((JsonObject)relation, (permissionId, actionId) -> actionList.add(jooq.fetchByIdAsync(actionId).compose(action -> {
                action.setPermissionId((String)permissionId);
                action.setUpdatedBy(userKey);
                action.setUpdatedAt(LocalDateTime.now());
                return Ux.future((Object)action);
            }).compose(arg_0 -> ((UxJooq)jooq).updateAsync(arg_0))));
            return Ux.thenCombineT(actionList);
        }).compose(nil -> Ux.future((Object)relation));
    }

    @Override
    public Future<JsonArray> syncAsync(JsonArray permissions, String roleId) {
        return (Future)Fn.getEmpty((Object)Ux.futureA(), () -> {
            JsonObject condition = new JsonObject();
            condition.put("roleId", roleId);
            UxJooq dao = Ux.Jooq.on(RRolePermDao.class);
            return dao.deleteByAsync(condition).compose(processed -> {
                ArrayList relations = new ArrayList();
                Ut.itJArray((JsonArray)permissions, String.class, (permissionId, index) -> {
                    RRolePerm item = new RRolePerm();
                    item.setRoleId(roleId);
                    item.setPermId((String)permissionId);
                    relations.add(item);
                });
                return dao.insertAsync(relations).compose(inserted -> Sc.cachePermission(roleId, permissions).compose(nil -> Ux.future((Object)inserted))).compose(Ux::futureA);
            });
        }, (String[])new String[]{roleId});
    }

    @Override
    public Future<JsonObject> searchAsync(JsonObject query, String sigma) {
        return Ux.Jooq.on(SPermSetDao.class).fetchAsync("sigma", (Object)sigma).compose(setList -> {
            Set codes = setList.stream().map(SPermSet::getCode).collect(Collectors.toSet());
            JsonObject criteriaRef = query.getJsonObject("criteria");
            JsonObject criteria = new JsonObject();
            criteria.put("sigma", sigma);
            criteria.put("code,!i", Ut.toJArray(codes));
            criteria.put("", Boolean.TRUE);
            if (Ut.notNil((JsonObject)criteriaRef)) {
                criteria.put("$0", criteriaRef.copy());
            }
            query.put("criteria", criteria);
            return Ux.Jooq.on(SPermissionDao.class).searchAsync(query);
        });
    }

    @Override
    public Future<JsonObject> fetchAsync(String key) {
        return Ux.Jooq.on(SPermissionDao.class).fetchByIdAsync((Object)key).compose(permission -> this.actionStub.fetchAction(permission.getKey()).compose(Ux.futureJM((Object)permission, (String)"actions")));
    }

    @Override
    public Future<JsonObject> createAsync(JsonObject body) {
        JsonArray actions = body.getJsonArray("actions");
        body.remove("actions");
        return Ux.Jooq.on(SPermissionDao.class).insertAsync(body).compose(permission -> this.actionStub.saveAction((SPermission)permission, actions).compose(Ux.futureJM((Object)permission, (String)"actions")));
    }

    @Override
    public Future<JsonObject> updateAsync(String key, JsonObject body) {
        JsonArray actions = body.getJsonArray("actions");
        body.remove("actions");
        return Ux.Jooq.on(SPermissionDao.class).updateAsync((Object)key, body).compose(permission -> this.actionStub.saveAction((SPermission)permission, actions).compose(Ux.futureJM((Object)permission, (String)"actions")));
    }

    @Override
    public Future<Boolean> deleteAsync(String key, String userKey) {
        return Ux.Jooq.on(SPermissionDao.class).deleteByIdAsync((Object)key).compose(nil -> this.actionStub.removeAction(key, userKey));
    }
}

