/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.view;

import cn.vertxup.rbac.domain.tables.daos.SViewDao;
import cn.vertxup.rbac.domain.tables.pojos.SPath;
import cn.vertxup.rbac.domain.tables.pojos.SView;
import cn.vertxup.rbac.service.view.RuleRobin;
import cn.vertxup.rbac.service.view.RuleStub;
import cn.vertxup.rbac.service.view.VisitStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class RuleService
implements RuleStub {
    @Inject
    private transient VisitStub visitStub;

    @Override
    public Future<JsonArray> procAsync(List<SPath> paths) {
        List filtered = paths.stream().filter(Objects::nonNull).collect(Collectors.toList());
        return Ux.thenCombineT(filtered, RuleRobin::procRule).compose(Ux::futureA);
    }

    @Override
    public Future<JsonArray> fetchViews(String ownerType, String ownerId, JsonArray keys, String view) {
        JsonObject condition = new JsonObject();
        condition.put("owner", ownerId);
        condition.put("ownerType", ownerType);
        condition.put("resourceId,i", keys);
        condition.put("name", view);
        return Ux.Jooq.on(SViewDao.class).fetchAndAsync(condition).compose(Ux::futureA).compose(Ke.mounts((String[])new String[]{"rows", "criteria"})).compose(result -> {
            Ut.itJArray((JsonArray)result).forEach(json -> Ke.mountArray((JsonObject)json, (String)"projection"));
            return Ux.future((Object)result);
        });
    }

    @Override
    public Future<JsonArray> saveViews(String ownerType, String ownerId, JsonArray views, String view) {
        Set keySet = Ut.mapString((JsonArray)views, (String)"resourceId");
        ConcurrentMap newMap = Ut.elementMap((JsonArray)views, (String)"resourceId");
        return this.fetchViews(ownerType, ownerId, Ut.toJArray((Set)keySet), view).compose(original -> {
            ConcurrentMap oldMap = Ut.elementMap((JsonArray)original, (String)"resourceId");
            ArrayList addQueue = new ArrayList();
            ArrayList upQueue = new ArrayList();
            newMap.keySet().forEach(resourceId -> {
                if (oldMap.containsKey(resourceId)) {
                    JsonObject previous = (JsonObject)oldMap.get(resourceId);
                    previous.mergeIn((JsonObject)newMap.get(resourceId));
                    SView normalized = (SView)Ut.deserialize((JsonObject)previous.copy(), SView.class);
                    upQueue.add(normalized);
                } else {
                    JsonObject added = (JsonObject)newMap.get(resourceId);
                    SView normalized = (SView)Ut.deserialize((JsonObject)added.copy(), SView.class);
                    normalized.setActive(Boolean.TRUE);
                    normalized.setName("DEFAULT");
                    addQueue.add(normalized);
                }
            });
            UxJooq jooq = Ux.Jooq.on(SViewDao.class);
            JsonArray response = new JsonArray();
            return jooq.updateAsync(upQueue).compose(Ux::futureA).compose(updated -> {
                response.addAll(updated);
                return Ux.future();
            }).compose(nil -> jooq.insertAsync(addQueue)).compose(Ux::futureA).compose(Ke.mounts((String[])new String[]{"rows", "criteria"})).compose(result -> {
                Ut.itJArray((JsonArray)result).forEach(json -> Ke.mountArray((JsonObject)json, (String)"projection"));
                return Ux.future((Object)result);
            }).compose(inserted -> {
                response.addAll(inserted);
                return Ux.future((Object)response);
            });
        }).compose(viewData -> this.saveVisitants((JsonArray)viewData, newMap));
    }

    private Future<JsonArray> saveVisitants(JsonArray views, ConcurrentMap<String, JsonObject> resourceMap) {
        ArrayList futures = new ArrayList();
        Ut.itJArray((JsonArray)views).filter(view -> view.getBoolean("visitant", Boolean.FALSE)).forEach(view -> {
            JsonObject visitantData;
            JsonObject requestData;
            String resourceId = view.getString("resourceId");
            if (Ut.notNil((String)resourceId) && resourceMap.containsKey(resourceId) && (requestData = (JsonObject)resourceMap.get(resourceId)).containsKey("visitantData") && Ut.notNil((JsonObject)(visitantData = requestData.getJsonObject("visitantData")))) {
                futures.add(this.visitStub.saveAsync(visitantData.copy(), (JsonObject)view).compose(processed -> Ux.future((Object)view.put("visitantData", processed))));
            }
        });
        return Ux.thenCombine(futures).compose(nil -> Ux.future((Object)views));
    }
}

