/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.view.source;

import cn.vertxup.rbac.service.view.RuleSource;
import cn.vertxup.rbac.service.view.source.RadixTool;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import java.util.Objects;

public class RadixUi
implements RuleSource {
    private static final Annal LOGGER = Annal.get(RadixUi.class);

    @Override
    public Future<JsonObject> procAsync(JsonObject inputData, JsonObject config) {
        JsonObject condition = RadixTool.toCriteria(inputData, config.getJsonObject("uiCondition"));
        LOGGER.info("Condition for Rule: input = {0}, normalized = {1}", new Object[]{inputData.encode(), condition.encode()});
        UxJooq dao = RadixTool.toDao(config.getString("uiComponent"));
        if (Objects.isNull(dao)) {
            return RadixTool.toResponse(new JsonArray());
        }
        return dao.fetchAsync(condition).compose(Ux::futureA).compose(RadixTool::toResponse);
    }
}

