/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.atom;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.atom.ProfileGroup;
import io.vertx.tp.rbac.atom.ProfileRole;
import io.vertx.tp.rbac.authorization.Align;
import io.vertx.tp.rbac.authorization.ScDetent;
import io.vertx.tp.rbac.permission.ScPrivilege;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.atom.Refer;
import io.vertx.up.atom.unity.Uson;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ScSession {
    private static final Annal LOGGER = Annal.get(ScSession.class);

    public static Future<Boolean> initAuthorization(JsonObject data) {
        return ScPrivilege.init(data).compose(reference -> reference.evaluate(profile -> ScSession.initRoles(profile, data.getJsonArray("role")).compose(processed -> ScSession.initGroups(processed, data.getJsonArray("group"))).compose(reference::storeProfile).compose(result -> Uson.create((JsonObject)data).append("profile", profile).toFuture()).compose(ScSession::onReport).compose(nil -> Ux.future((Object)Boolean.TRUE))));
    }

    private static Future<JsonObject> initRoles(JsonObject profile, JsonArray roles) {
        Sc.infoAuth(LOGGER, "Roles : {0}", roles.encode());
        ArrayList futures = new ArrayList();
        roles.stream().filter(Objects::nonNull).map(item -> (JsonObject)item).map(ProfileRole::new).map(ProfileRole::initAsync).forEach(futures::add);
        return CompositeFuture.join(futures).compose(Sc::composite).compose(ScDetent.user(profile)::procAsync);
    }

    private static Future<JsonObject> initGroups(JsonObject profile, JsonArray groups) {
        Sc.debugAuth(LOGGER, "Groups: {0}", groups.encode());
        ArrayList futures = new ArrayList();
        groups.stream().filter(Objects::nonNull).map(item -> (JsonObject)item).map(ProfileGroup::new).map(ProfileGroup::initAsync).forEach(futures::add);
        Refer parentHod = new Refer();
        Refer childHod = new Refer();
        return CompositeFuture.join(futures).compose(Sc::composite).compose(profiles -> Ux.future((Object)profiles).compose(Align::flat).compose(ScDetent.group(profile)::procAsync).compose(nil -> Ux.future((Object)profiles)).compose(Align::parent).compose(arg_0 -> ((Refer)parentHod).future(arg_0)).compose(parents -> ScDetent.parent(profile, profiles).procAsync((List<ProfileRole>)parents)).compose(nil -> ScDetent.inherit(profile, profiles).procAsync((List)parentHod.get())).compose(nil -> Ux.future((Object)profiles)).compose(Align::children).compose(arg_0 -> ((Refer)childHod).future(arg_0)).compose(children -> ScDetent.children(profile, profiles).procAsync((List<ProfileRole>)children)).compose(nil -> ScDetent.extend(profile, profiles).procAsync((List)childHod.get())).compose(nil -> Ux.future((Object)profiles))).compose(nil -> Ux.future((Object)profile));
    }

    private static Future<JsonObject> onReport(JsonObject result) {
        Sc.infoAuth(LOGGER, "Permissions: {0}", result.encode());
        return Future.succeededFuture((Object)result);
    }
}

