/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.authorization;

import cn.vertxup.rbac.domain.tables.pojos.SGroup;
import cn.vertxup.rbac.service.business.GroupService;
import cn.vertxup.rbac.service.business.GroupStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.atom.ProfileGroup;
import io.vertx.tp.rbac.atom.ProfileRole;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Align {
    private static final GroupStub STUB = (GroupStub)Ut.singleton(GroupService.class, (Object[])new Object[0]);

    public static ProfileGroup eager(List<ProfileGroup> groups) {
        return groups.stream().min(Comparator.comparing(ProfileGroup::getPriority)).orElse(null);
    }

    public static ProfileGroup lazy(List<ProfileGroup> groups) {
        return groups.stream().max(Comparator.comparing(ProfileGroup::getPriority)).orElse(null);
    }

    public static Future<List<ProfileRole>> flat(List<ProfileGroup> profiles) {
        return Ux.future(profiles.stream().flatMap(group -> group.getRoles().stream()).collect(Collectors.toList()));
    }

    public static Future<List<ProfileRole>> parent(List<ProfileGroup> profiles) {
        return Align.flat(profiles.stream().map(Align::findParent).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public static Future<List<ProfileRole>> children(List<ProfileGroup> profiles) {
        return Align.flat(profiles.stream().map(Align::findChildren).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private static List<ProfileGroup> findChildren(ProfileGroup current) {
        String groupId = current.getKey();
        List<SGroup> groups = STUB.fetchChildren(groupId);
        return groups.stream().filter(Objects::nonNull).map(group -> Align.toProfile(group, current)).filter(Objects::nonNull).map(children -> children.setReference(current.getKey())).collect(Collectors.toList());
    }

    private static ProfileGroup findParent(ProfileGroup current) {
        String groupId = current.getKey();
        SGroup group = STUB.fetchParent(groupId);
        ProfileGroup parent = Align.toProfile(group, current);
        if (Objects.nonNull(parent)) {
            current.setReference(parent.getKey());
        }
        return parent;
    }

    private static ProfileGroup toProfile(SGroup group, ProfileGroup current) {
        if (null == group) {
            return null;
        }
        JsonObject groupData = new JsonObject();
        groupData.put("groupId", group.getKey());
        groupData.put("priority", current.getPriority());
        JsonArray roles = STUB.fetchRoleIds(group.getKey());
        groupData.put("role", roles);
        return new ProfileGroup(groupData).init();
    }
}

