/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.authorization;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.atom.ProfileGroup;
import io.vertx.tp.rbac.atom.ProfileRole;
import io.vertx.tp.rbac.atom.ProfileType;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Assembler {
    public static List<ProfileRole> connect(List<ProfileRole> profiles, List<ProfileGroup> original) {
        Set originalSet = original.stream().flatMap(group -> group.getRoles().stream()).collect(Collectors.toSet());
        originalSet.addAll(profiles);
        return new ArrayList<ProfileRole>(originalSet);
    }

    public static List<ProfileRole> connect(List<ProfileRole> profiles, ProfileGroup original) {
        List<Object> eagerRoles = Objects.isNull(original) ? new ArrayList() : original.getRoles();
        HashSet<ProfileRole> originalSet = new HashSet<ProfileRole>(eagerRoles);
        originalSet.addAll(profiles);
        return new ArrayList<ProfileRole>(originalSet);
    }

    public static Consumer<JsonObject> union(ProfileType type, List<ProfileRole> profiles) {
        return Assembler.bind(type, profiles, Ut::union);
    }

    public static Consumer<JsonObject> intersect(ProfileType type, List<ProfileRole> profiles) {
        return Assembler.bind(type, profiles, Ut::intersect);
    }

    public static Consumer<JsonObject> eager(ProfileType type, List<ProfileRole> profiles) {
        return Assembler.bind(type, profiles, true);
    }

    public static Consumer<JsonObject> lazy(ProfileType type, List<ProfileRole> profiles) {
        return Assembler.bind(type, profiles, false);
    }

    private static Consumer<JsonObject> bind(ProfileType type, List<ProfileRole> profiles, BinaryOperator<Set<String>> fnReduce) {
        return input -> {
            if (Objects.nonNull(input) && !profiles.isEmpty()) {
                ProfileRole first = (ProfileRole)profiles.iterator().next();
                JsonArray roles = new JsonArray();
                JsonArray permissions = Ut.toJArray((Set)profiles.stream().filter(Objects::nonNull).map(Assembler.bindRole(roles)).map(ProfileRole::getAuthorities).reduce(first.getAuthorities(), fnReduce));
                input.put(type.getKey(), Assembler.bindResult(permissions, roles));
            } else {
                input.put(type.getKey(), Assembler.bindResult(null, null));
            }
        };
    }

    private static JsonObject bindResult(JsonArray permissions, JsonArray roles) {
        JsonObject profile = new JsonObject();
        profile.put("PERM", Objects.isNull(permissions) ? new JsonArray() : permissions);
        profile.put("ROLE", Objects.isNull(roles) ? new JsonArray() : roles);
        return profile;
    }

    private static Function<ProfileRole, ProfileRole> bindRole(JsonArray roles) {
        return profile -> {
            roles.add(profile.getKey());
            return profile;
        };
    }

    private static Consumer<JsonObject> bind(ProfileType type, List<ProfileRole> profiles, boolean highPriority) {
        return input -> {
            if (Objects.nonNull(input) && !profiles.isEmpty()) {
                JsonArray roles = new JsonArray();
                JsonArray permissions = highPriority ? Ut.toJArray((Set)profiles.stream().min(Comparator.comparing(ProfileRole::getPriority)).map(Assembler.bindRole(roles)).map(ProfileRole::getAuthorities).orElse(new HashSet())) : Ut.toJArray((Set)profiles.stream().max(Comparator.comparing(ProfileRole::getPriority)).map(Assembler.bindRole(roles)).map(ProfileRole::getAuthorities).orElse(new HashSet()));
                input.put(type.getKey(), Assembler.bindResult(permissions, roles));
            } else {
                input.put(type.getKey(), Assembler.bindResult(null, null));
            }
        };
    }
}

