/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.batch;

import cn.vertxup.rbac.service.batch.IdcStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.atom.KCredential;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.optic.Credential;
import io.vertx.tp.optic.business.ExModel;
import io.vertx.up.exception.web._400BadRequestException;
import io.vertx.up.exception.web._400SigmaMissingException;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class AbstractIdc
implements IdcStub {
    protected final transient String sigma;

    public AbstractIdc(String sigma) {
        this.sigma = sigma;
    }

    protected <T> Future<T> credential(Supplier<Future<T>> supplier, Function<KCredential, Future<T>> executor) {
        return Ke.channelAsync(Credential.class, supplier, stub -> stub.fetchAsync(this.sigma).compose(executor));
    }

    protected Future<JsonArray> model(JsonArray userJson) {
        return Ke.channelAsync(ExModel.class, () -> Ux.future((Object)userJson), stub -> stub.keyAsync(this.sigma, userJson).compose(keyMap -> {
            Ut.itJArray((JsonArray)userJson).forEach(user -> {
                String username = user.getString("username");
                JsonObject data = (JsonObject)keyMap.get(username);
                if (Ut.notNil((JsonObject)data)) {
                    user.mergeIn(data.copy(), true);
                }
            });
            return Ux.future((Object)userJson);
        }));
    }

    protected <T> Future<T> runPre(T user) {
        if (Ut.isNil((String)this.sigma)) {
            return Future.failedFuture((Throwable)new _400SigmaMissingException(this.getClass()));
        }
        if (Objects.isNull(user)) {
            return Future.failedFuture((Throwable)new _400BadRequestException(this.getClass()));
        }
        return Ux.future(user);
    }
}

