/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.view;

import cn.vertxup.rbac.domain.tables.daos.SViewDao;
import cn.vertxup.rbac.domain.tables.daos.SVisitantDao;
import cn.vertxup.rbac.domain.tables.pojos.SVisitant;
import cn.vertxup.rbac.service.view.VisitStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;

public class VisitService
implements VisitStub {
    @Override
    public Future<JsonObject> fetchVisitant(String ownerType, String ownerId, JsonObject request) {
        JsonObject input = Ut.sureJObject((JsonObject)request);
        Sc.infoView(this.getClass(), "Visitant Request: {0}", input);
        String resourceId = input.getString("resourceId");
        String type = input.getString("type");
        if (Ut.isNilOr((String[])new String[]{resourceId, type})) {
            return Ux.futureJ();
        }
        String identifier = request.getString("identifier");
        String configKey = request.getString("configKey");
        if (Ut.isNil((String)identifier) && Ut.isNil((String)configKey)) {
            return Ux.futureJ();
        }
        JsonObject condition = new JsonObject();
        condition.put("owner", ownerId);
        condition.put("ownerType", ownerType);
        condition.put("name", "DEFAULT");
        condition.put("resourceId", resourceId);
        Sc.infoView(this.getClass(), "Visitant View: {0}", condition.encode());
        return Ux.Jooq.on(SViewDao.class).fetchOneAsync(condition).compose(view -> {
            if (Objects.isNull(view)) {
                return Ux.futureJ();
            }
            JsonObject criteria = new JsonObject();
            criteria.put("viewId", view.getKey());
            criteria.put("type", type);
            criteria.put("sigma", view.getSigma());
            if (Ut.notNil((String)identifier)) {
                criteria.put("identifier", identifier);
                criteria.put("configKey", "DEFAULT");
            } else {
                criteria.put("configKey", configKey);
            }
            Sc.infoView(this.getClass(), "Visitant Record: {0}", criteria.encode());
            return Ux.Jooq.on(SVisitantDao.class).fetchOneAsync(criteria).compose(Ux::futureJ).compose(Ut.ifJObject((String[])new String[]{"aclVisible", "aclView", "aclVariety", "aclVow", "aclVerge"}));
        });
    }

    @Override
    public Future<JsonObject> saveAsync(JsonObject request, JsonObject view) {
        Ut.jsonCopy((JsonObject)request, (JsonObject)view, (String[])new String[]{"sigma", "language", "active"});
        request.put("viewId", view.getValue("key"));
        JsonObject criteria = new JsonObject();
        Ut.jsonCopy((JsonObject)criteria, (JsonObject)request, (String[])new String[]{"viewId", "type", "sigma"});
        String configKey = request.getString("configKey");
        if (Ut.isNil((String)configKey)) {
            criteria.put("identifier", request.getValue("identifier"));
            criteria.put("configKey", "DEFAULT");
        } else {
            criteria.put("configKey", configKey);
        }
        Sc.infoView(this.getClass(), "Visitant Upsert: {0}, Data: {1}", criteria.encode(), request.encode());
        Ut.ifString((JsonObject)request, (String[])new String[]{"aclVisible", "aclView", "aclVariety", "aclVow", "aclVerge"});
        SVisitant visitant = (SVisitant)Ut.deserialize((JsonObject)request, SVisitant.class);
        return Ux.Jooq.on(SVisitantDao.class).upsertAsync(criteria, (Object)visitant).compose(Ux::futureJ).compose(Ut.ifJObject((String[])new String[]{"aclVisible", "aclView", "aclVariety", "aclVow", "aclVerge"}));
    }
}

