/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.authorization;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.atom.ProfileGroup;
import io.vertx.tp.rbac.atom.ProfileRole;
import io.vertx.tp.rbac.authorization.Pool;
import io.vertx.tp.rbac.authorization.child.GcCritical;
import io.vertx.tp.rbac.authorization.child.GcHorizon;
import io.vertx.tp.rbac.authorization.child.GcOverlook;
import io.vertx.tp.rbac.authorization.detent.ScDetentChild;
import io.vertx.tp.rbac.authorization.detent.ScDetentExtend;
import io.vertx.tp.rbac.authorization.detent.ScDetentGroup;
import io.vertx.tp.rbac.authorization.detent.ScDetentInherit;
import io.vertx.tp.rbac.authorization.detent.ScDetentParent;
import io.vertx.tp.rbac.authorization.detent.ScDetentRole;
import io.vertx.tp.rbac.authorization.direct.GdCritical;
import io.vertx.tp.rbac.authorization.direct.GdHorizon;
import io.vertx.tp.rbac.authorization.direct.GdOverlook;
import io.vertx.tp.rbac.authorization.extend.GeCritical;
import io.vertx.tp.rbac.authorization.extend.GeHorizon;
import io.vertx.tp.rbac.authorization.extend.GeOverlook;
import io.vertx.tp.rbac.authorization.inherit.GiCritical;
import io.vertx.tp.rbac.authorization.inherit.GiHorizon;
import io.vertx.tp.rbac.authorization.inherit.GiOverlook;
import io.vertx.tp.rbac.authorization.parent.GpCritical;
import io.vertx.tp.rbac.authorization.parent.GpHorizon;
import io.vertx.tp.rbac.authorization.parent.GpOverlook;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import java.util.List;

public interface ScDetent {
    public static ScDetent user(JsonObject input) {
        return new ScDetentRole(input);
    }

    public static ScDetent group(JsonObject input) {
        return new ScDetentGroup(input);
    }

    public static ScDetent parent(JsonObject input, List<ProfileGroup> profiles) {
        return new ScDetentParent(input, profiles);
    }

    public static ScDetent inherit(JsonObject input, List<ProfileGroup> profiles) {
        return new ScDetentInherit(input, profiles);
    }

    public static ScDetent extend(JsonObject input, List<ProfileGroup> profiles) {
        return new ScDetentExtend(input, profiles);
    }

    public static ScDetent children(JsonObject input, List<ProfileGroup> profiles) {
        return new ScDetentChild(input, profiles);
    }

    public JsonObject proc(List<ProfileRole> var1);

    default public Future<JsonObject> procAsync(List<ProfileRole> profiles) {
        return Ux.future((Object)this.proc(profiles));
    }

    public static interface Group {
        public static ScDetent horizon() {
            return (ScDetent)Fn.pool(Pool.DETENT_POOL, (Object)GdHorizon.class.getName(), GdHorizon::new);
        }

        public static ScDetent critical() {
            return (ScDetent)Fn.pool(Pool.DETENT_POOL, (Object)GdCritical.class.getName(), GdCritical::new);
        }

        public static ScDetent overlook() {
            return (ScDetent)Fn.pool(Pool.DETENT_POOL, (Object)GdOverlook.class.getName(), GdOverlook::new);
        }

        public static interface Extend {
            public static ScDetent horizon(List<ProfileGroup> original) {
                return new GeHorizon(original);
            }

            public static ScDetent critical(List<ProfileGroup> original) {
                return new GeCritical(original);
            }

            public static ScDetent overlook(List<ProfileGroup> original) {
                return new GeOverlook(original);
            }
        }

        public static interface Inherit {
            public static ScDetent horizon(List<ProfileGroup> original) {
                return new GiHorizon(original);
            }

            public static ScDetent critical(List<ProfileGroup> original) {
                return new GiCritical(original);
            }

            public static ScDetent overlook(List<ProfileGroup> original) {
                return new GiOverlook(original);
            }
        }

        public static interface Child {
            public static ScDetent horizon() {
                return (ScDetent)Fn.pool(Pool.DETENT_POOL, (Object)GcHorizon.class.getName(), GcHorizon::new);
            }

            public static ScDetent critical(List<ProfileGroup> original) {
                return new GcCritical(original);
            }

            public static ScDetent overlook(List<ProfileGroup> original) {
                return new GcOverlook(original);
            }
        }

        public static interface Parent {
            public static ScDetent horizon() {
                return (ScDetent)Fn.pool(Pool.DETENT_POOL, (Object)GpHorizon.class.getName(), GpHorizon::new);
            }

            public static ScDetent critical(List<ProfileGroup> original) {
                return new GpCritical(original);
            }

            public static ScDetent overlook(List<ProfileGroup> original) {
                return new GpOverlook(original);
            }
        }
    }
}

