/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.api;

import cn.vertxup.rbac.domain.tables.daos.SActionDao;
import cn.vertxup.rbac.domain.tables.daos.SResourceDao;
import cn.vertxup.rbac.service.business.ResourceStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Queue;
import io.vertx.up.unity.Ux;
import javax.inject.Inject;

@Queue
public class ResourceActor {
    @Inject
    private transient ResourceStub resourceStub;

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-RESOURCE/SEARCH")
    public Future<JsonObject> searchResource(JsonObject query) {
        Sc.infoWeb(this.getClass(), "The criteria of input parameters: {0}", query.encode());
        return Ux.Join.on().add(SResourceDao.class).join(SActionDao.class, "resourceId").searchAsync(query);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-RESOURCE/GET-CASCADE")
    public Future<JsonObject> getById(String key) {
        return this.resourceStub.fetchResource(key);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-RESOURCE/ADD-CASCADE")
    public Future<JsonObject> create(JsonObject data) {
        return this.resourceStub.createResource(data);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-RESOURCE/UPDATE-CASCADE")
    public Future<JsonObject> update(String key, JsonObject data) {
        return this.resourceStub.updateResource(key, data);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-RESOURCE/DELETE-CASCADE")
    public Future<Boolean> delete(String key) {
        return this.resourceStub.deleteResource(key);
    }
}

