/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.accredit;

import cn.vertxup.rbac.domain.tables.pojos.SAction;
import cn.vertxup.rbac.domain.tables.pojos.SResource;
import cn.vertxup.rbac.service.accredit.AccreditStub;
import cn.vertxup.rbac.service.accredit.ActionStub;
import cn.vertxup.rbac.service.accredit.MatrixStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.tp.error._403ActionDinnedException;
import io.vertx.tp.error._404ActionMissingException;
import io.vertx.tp.error._404ResourceMissingException;
import io.vertx.tp.rbac.logged.ScResource;
import io.vertx.tp.rbac.logged.ScUser;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.atom.Refer;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import javax.inject.Inject;

public class AccreditService
implements AccreditStub {
    private static final Annal LOGGER = Annal.get(AccreditService.class);
    @Inject
    private transient ActionStub stub;
    @Inject
    private transient MatrixStub matrixStub;

    @Override
    public Future<JsonObject> profile(User user) {
        ScUser scUser = ScUser.login(user);
        return scUser.permissions();
    }

    @Override
    public Future<JsonObject> resource(JsonObject requestData) {
        ScResource request = ScResource.create(requestData);
        return request.resource().compose(data -> {
            if (Ut.isNil((JsonObject)data)) {
                Refer actionHod = new Refer();
                return this.fetchAction(request).compose(action -> this.inspectAction(request, (SAction)action)).compose(arg_0 -> ((Refer)actionHod).future(arg_0)).compose(action -> this.stub.fetchResource(action.getResourceId())).compose(resource -> this.inspectResource(request, (SAction)actionHod.get(), (SResource)resource)).compose(resource -> this.inspectLevel((SResource)resource, (SAction)actionHod.get())).compose(resource -> this.inspectData((SResource)resource, (SAction)actionHod.get())).compose(request::resource);
            }
            Sc.infoAuth(LOGGER, "ScResource: \u001b[0;37m----> Cache key = {0}\u001b[m.", request.key());
            return Ux.future((Object)data);
        }).compose(stored -> this.inspectView(requestData, request, (JsonObject)stored)).compose(stored -> Ux.future((Object)stored.getJsonObject("data")));
    }

    private Future<JsonObject> inspectView(JsonObject requestData, ScResource resource, JsonObject response) {
        String habitus = requestData.getString("habitus");
        String keyView = resource.keyView();
        ScUser user = ScUser.login(habitus);
        return user.view(keyView).compose(viewData -> {
            if (Objects.isNull(viewData)) {
                return this.matrixStub.fetchBound(user, resource).compose(bound -> user.view(keyView, bound.toJson())).compose(nil -> Ux.future((Object)response));
            }
            return Ux.future((Object)response);
        });
    }

    private Future<JsonObject> inspectData(SResource resource, SAction action) {
        String profileKey = Sc.valueProfile(resource);
        JsonArray permissions = new JsonArray().add((Object)action.getPermissionId());
        JsonObject stored = new JsonObject();
        stored.put("record", (Object)Ut.serializeJson((Object)resource));
        stored.put("key", (Object)profileKey);
        stored.put("data", (Object)new JsonObject().put(profileKey, (Object)permissions));
        return Ux.future((Object)stored);
    }

    private Future<SResource> inspectLevel(SResource resource, SAction action) {
        Integer required = resource.getLevel();
        Integer actual = action.getLevel();
        if (actual < required) {
            _403ActionDinnedException error = new _403ActionDinnedException(this.getClass(), required, actual);
            return Future.failedFuture((Throwable)((Object)error));
        }
        Sc.debugCredit(LOGGER, "3. Accredit level ( action = {0}, resource = {1} ).", action.getLevel(), resource.getLevel());
        return Future.succeededFuture((Object)resource);
    }

    private Future<SAction> inspectAction(ScResource request, SAction action) {
        if (Objects.isNull(action)) {
            String requestUri = request.method() + " " + request.uri();
            _404ActionMissingException error = new _404ActionMissingException(this.getClass(), requestUri);
            return Future.failedFuture((Throwable)((Object)error));
        }
        Sc.debugCredit(LOGGER, "1. Accredit action ( uri = `{0}`, method = `{1}`, normalizedUri = `{2}` ).", request.uriRequest(), request.method(), request.uri());
        return Future.succeededFuture((Object)action);
    }

    private Future<SResource> inspectResource(ScResource request, SAction action, SResource resource) {
        if (Objects.isNull(resource)) {
            String requestUri = request.method() + " " + request.uri();
            _404ResourceMissingException error = new _404ResourceMissingException(this.getClass(), action.getResourceId(), requestUri);
            return Future.failedFuture((Throwable)((Object)error));
        }
        Sc.debugCredit(LOGGER, "2. Accredit resource ( resource = `{0}` ).", resource.getKey());
        return Future.succeededFuture((Object)resource);
    }

    private Future<SAction> fetchAction(ScResource resource) {
        return this.stub.fetchAction(resource.uri(), resource.method(), resource.sigma()).compose(action -> {
            if (Objects.nonNull(action)) {
                return Ux.future((Object)action);
            }
            if (resource.isNormalized()) {
                return this.stub.fetchAction(resource.uriRequest(), resource.method(), resource.sigma());
            }
            return Ux.future();
        });
    }
}

