/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.accredit;

import cn.vertxup.rbac.domain.tables.daos.SActionDao;
import cn.vertxup.rbac.domain.tables.daos.SResourceDao;
import cn.vertxup.rbac.domain.tables.pojos.SAction;
import cn.vertxup.rbac.domain.tables.pojos.SPermission;
import cn.vertxup.rbac.domain.tables.pojos.SResource;
import cn.vertxup.rbac.service.accredit.ActionStub;
import io.vertx.core.Future;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.optic.business.ExRoute;
import io.vertx.up.runtime.soul.UriAeon;
import io.vertx.up.runtime.soul.UriMeta;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;

public class ActionService
implements ActionStub {
    @Override
    public Future<SAction> fetchAction(String normalizedUri, HttpMethod method) {
        return this.fetchAction(normalizedUri, method, null);
    }

    @Override
    public Future<List<SAction>> fetchAction(String permissionId) {
        return Ux.Jooq.on(SActionDao.class).fetchAsync("permissionId", (Object)permissionId);
    }

    @Override
    public Future<SAction> fetchAction(String normalizedUri, HttpMethod method, String sigma) {
        JsonObject actionFilters = new JsonObject();
        actionFilters.put("", (Object)Boolean.TRUE);
        actionFilters.put("uri", (Object)normalizedUri);
        if (Ut.notNil((String)sigma)) {
            actionFilters.put("sigma", (Object)sigma);
        }
        actionFilters.put("method", (Object)method.name());
        return Ux.Jooq.on(SActionDao.class).fetchOneAsync(actionFilters);
    }

    @Override
    public Future<SResource> fetchResource(String key) {
        return Ux.Jooq.on(SResourceDao.class).fetchByIdAsync((Object)key);
    }

    @Override
    public Future<List<SAction>> searchAuthorized(String keyword, String sigma) {
        if (Ut.isNil((String)sigma) || Ut.isNil((String)keyword)) {
            return Ux.future(new ArrayList());
        }
        JsonObject condition = new JsonObject();
        condition.put("sigma", (Object)sigma);
        JsonArray methods = new JsonArray();
        methods.add((Object)HttpMethod.POST.name());
        methods.add((Object)HttpMethod.GET.name());
        condition.put("method", (Object)methods);
        JsonObject criteria = new JsonObject();
        criteria.put("name,c", (Object)keyword);
        criteria.put("code,c", (Object)keyword);
        criteria.put("uri,c", (Object)keyword);
        condition.put("$0", (Object)criteria);
        return Ux.Jooq.on(SActionDao.class).fetchAndAsync(condition);
    }

    @Override
    public Future<List<UriMeta>> searchAll(String keyword, String sigma) {
        List staticList = UriAeon.uriSearch((String)keyword);
        return Ke.channel(ExRoute.class, ArrayList::new, route -> route.searchAsync(keyword, sigma)).compose(uris -> {
            ArrayList<UriMeta> resultList = new ArrayList<UriMeta>((Collection<UriMeta>)uris);
            resultList.addAll(staticList);
            resultList.sort(Comparator.comparing(UriMeta::getUri));
            return Ux.future(resultList);
        });
    }

    @Override
    public Future<List<SAction>> saveAction(SPermission permission, JsonArray actionData) {
        return Ux.Jooq.on(SActionDao.class).fetchAsync("permissionId", (Object)permission.getKey()).compose(oldList -> {
            List inputList = Ux.fromJson((JsonArray)actionData, SAction.class);
            ConcurrentMap mapInput = Ut.elementMap((List)inputList, SAction::getKey);
            ConcurrentMap mapStored = Ut.elementMap((List)oldList, SAction::getKey);
            ArrayList updated = new ArrayList();
            oldList.forEach(original -> {
                if (!mapInput.containsKey(original.getKey())) {
                    this.setAction((SAction)original, permission, null);
                    updated.add(original);
                }
            });
            mapInput.keySet().stream().filter(key -> !mapStored.containsKey(key)).forEach(actionKey -> {
                SAction action = (SAction)mapInput.get(actionKey);
                this.setAction(action, permission, permission.getKey());
                updated.add(action);
            });
            return Ux.Jooq.on(SActionDao.class).updateAsync(updated);
        });
    }

    private void setAction(SAction action, SPermission permission, String permissionId) {
        action.setPermissionId(permissionId);
        action.setUpdatedAt(LocalDateTime.now());
        action.setUpdatedBy(permission.getUpdatedBy());
        action.setActive(Boolean.TRUE);
        action.setLanguage(permission.getLanguage());
        action.setSigma(permission.getSigma());
    }

    @Override
    public Future<Boolean> removeAction(String permissionId, String userKey) {
        return Ux.Jooq.on(SActionDao.class).fetchAsync("permissionId", (Object)permissionId).compose(actions -> {
            actions.forEach(action -> {
                action.setPermissionId(null);
                action.setUpdatedAt(LocalDateTime.now());
                action.setUpdatedBy(userKey);
            });
            return Ux.Jooq.on(SActionDao.class).updateAsync(actions);
        }).compose(nil -> Ux.future((Object)Boolean.TRUE));
    }
}

