/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.login;

import cn.vertxup.rbac.domain.tables.daos.OUserDao;
import cn.vertxup.rbac.service.jwt.JwtStub;
import cn.vertxup.rbac.service.login.AuthStub;
import cn.vertxup.rbac.service.login.CodeStub;
import cn.vertxup.rbac.service.login.LoginStub;
import cn.vertxup.rbac.service.login.TokenStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Session;
import io.vertx.tp.error._401CodeGenerationException;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import java.util.Objects;
import javax.inject.Inject;

public class AuthService
implements AuthStub {
    private static final Annal LOGGER = Annal.get(AuthService.class);
    @Inject
    private transient CodeStub codeStub;
    @Inject
    private transient LoginStub loginStub;
    @Inject
    private transient TokenStub tokenStub;
    @Inject
    private transient JwtStub jwtStub;

    @Override
    public Future<JsonObject> authorize(JsonObject filters) {
        Sc.infoAuth(LOGGER, "Authorization Code Filters: {0}", filters.encode());
        return Ux.Jooq.on(OUserDao.class).fetchOneAsync(filters).compose(item -> {
            if (Objects.isNull(item)) {
                return Ux.thenError(_401CodeGenerationException.class, (Object[])new Object[]{this.getClass(), filters.getString("clientId"), filters.getString("clientSecret")});
            }
            return this.codeStub.authorize(item.getClientId());
        });
    }

    @Override
    public Future<JsonObject> token(JsonObject params, Session session) {
        String code = params.getString("code");
        String clientId = params.getString("client_id");
        Sc.infoAuth(LOGGER, "Input data when verification: client_id = {0}, code = {1}", clientId, code);
        return this.tokenStub.execute(clientId, code, session).compose(data -> {
            String userKey = data.getString("user");
            Sc.infoAuth(LOGGER, "The system will singleton user''s principle information. user key: {0}.", userKey);
            return this.jwtStub.store(userKey, (JsonObject)data);
        });
    }

    @Override
    public Future<JsonObject> login(JsonObject params) {
        String username = params.getString("username");
        String password = params.getString("password");
        Sc.infoAuth(LOGGER, "Login processing execute ( username = {0} )", username);
        return this.loginStub.execute(username, password);
    }
}

