/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.wall.authorization;

import cn.vertxup.rbac.wall.authorization.ProfileAuthorization;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationProvider;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ProfileProvider
implements AuthorizationProvider {
    private final transient Aegis aegis;

    private ProfileProvider(Aegis aegis) {
        this.aegis = aegis;
    }

    public static AuthorizationProvider provider(Aegis aegis) {
        return new ProfileProvider(aegis);
    }

    public String getId() {
        return this.aegis.getType().key();
    }

    public void getAuthorizations(User user, Handler<AsyncResult<Void>> handler) {
        Method method = this.aegis.getAuthorizer().getAuthorization();
        Fn.safeJvm(() -> {
            Future future = (Future)method.invoke(this.aegis.getProxy(), user);
            future.onComplete(res -> {
                if (res.succeeded()) {
                    ConcurrentHashMap<String, Set<String>> profiles = new ConcurrentHashMap<String, Set<String>>();
                    Ut.itJObject((JsonObject)((JsonObject)res.result()), (values, field) -> profiles.put((String)field, Ut.toSet((JsonArray)values)));
                    ProfileAuthorization required = ProfileAuthorization.create(profiles);
                    user.authorizations().add(this.getId(), (Authorization)required);
                    handler.handle((Object)Future.succeededFuture());
                } else {
                    Throwable ex = res.cause();
                    handler.handle((Object)Future.failedFuture((Throwable)ex));
                }
            });
        });
    }
}

