/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic;

import cn.vertxup.rbac.service.view.ViewService;
import cn.vertxup.rbac.service.view.ViewStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.optic.ApeakMy;
import io.vertx.tp.optic.fantom.Anchoret;
import io.vertx.tp.rbac.logged.ScUser;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.atom.secure.Vis;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.function.Function;

public class ExColumnApeakMy
extends Anchoret<ApeakMy>
implements ApeakMy {
    private final transient ViewStub stub = (ViewStub)Ut.singleton(ViewService.class, (Object[])new Object[0]);

    public Future<JsonArray> fetchMy(JsonObject params) {
        String resourceId = params.getString("resourceId");
        if (Ut.isNil((String)resourceId)) {
            return Ux.futureA();
        }
        String userId = params.getString("user");
        Vis view = Vis.smart((Object)params.getValue("view"));
        return this.stub.fetchMatrix(userId, resourceId, view).compose(queried -> Objects.isNull(queried) ? Ux.future((Object)new JsonArray()) : Ux.future((Object)Ut.toJArray((String)queried.getProjection())));
    }

    public Future<JsonObject> saveMy(JsonObject params, JsonObject viewInput) {
        String resourceId = params.getString("resourceId");
        if (Ut.isNil((String)resourceId)) {
            return Ux.futureJ();
        }
        String userId = params.getString("user");
        JsonObject viewData = params.copy();
        JsonArray projection = viewInput.getJsonArray("projection");
        JsonObject criteria = viewInput.getJsonObject("criteria");
        return this.stub.saveMatrix(userId, viewData.put("resourceId", (Object)resourceId), projection, criteria).compose(flushed -> this.flush(params, (JsonObject)flushed));
    }

    private Future<JsonObject> flush(JsonObject params, JsonObject updated) {
        String habitus = params.getString("habitus");
        ScUser user = ScUser.login(habitus);
        String dataKey = params.getString("dataKey");
        JsonObject updatedData = new JsonObject();
        updatedData.put("projection", (Object)updated.getJsonArray("projection"));
        updatedData.put("criteria", (Object)updated.getJsonObject("criteria"));
        return user.view(dataKey, updatedData).compose(nil -> {
            Sc.infoAuth(this.getLogger(), "DataRegion Flush -> dataKey = {1}, habitus = {0}, data finished = {2}", habitus, dataKey, nil.encodePrettily());
            return Ux.future((Object)updated);
        });
    }

    private Future<JsonArray> uniform(JsonObject params, Function<String, Future<JsonArray>> function) {
        String resourceId = params.getString("resourceId");
        if (Ut.isNil((String)resourceId)) {
            return Ux.future((Object)new JsonArray());
        }
        return function.apply(resourceId);
    }
}

