/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.acl.rapid;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.acl.rapid.Dwarf;
import io.vertx.tp.rbac.acl.rapid.SiftCol;
import io.vertx.tp.rbac.acl.rapid.SiftRow;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.commune.secure.Acl;
import io.vertx.up.util.Ut;
import java.util.Objects;

class ArrayDwarf
implements Dwarf {
    ArrayDwarf() {
    }

    @Override
    public void minimize(JsonObject dataReference, JsonObject matrix, Acl acl) {
        JsonArray inputArray = dataReference.getJsonArray("data");
        JsonArray updated = SiftRow.onRows(inputArray, matrix.getJsonObject("rows"));
        if (Objects.nonNull(acl)) {
            JsonObject config = acl.config();
            if (Ut.isNil((JsonObject)config) || Ut.isNil((JsonObject)config.getJsonObject("rows"))) {
                updated = SiftCol.onProjection(updated, Sc.aclOn(matrix.getJsonArray("projection"), acl));
            } else {
                updated = SiftCol.onProjection(updated, matrix.getJsonArray("projection"));
                JsonObject rows = SiftRow.onAcl(config.getJsonObject("rows"), acl.aclVisible());
                if (Objects.nonNull(rows)) {
                    updated = SiftRow.onRows(updated, rows);
                }
            }
        }
        dataReference.put("data", (Object)updated);
    }
}

