/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.acl.rapid;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;

class SiftRow {
    private static final Annal LOGGER = Annal.get(SiftRow.class);

    SiftRow() {
    }

    static JsonObject onAcl(JsonObject rows, Set<String> visible) {
        JsonObject result = new JsonObject();
        JsonArray fields = Ut.sureJArray((JsonArray)rows.getJsonArray("condition"));
        if (Ut.notNil((JsonArray)fields)) {
            Ut.itJArray((JsonArray)fields, String.class, (field, index) -> {
                JsonArray visibleFields = Ut.toJArray((Set)visible);
                result.put(field, (Object)visibleFields);
            });
            return result;
        }
        return null;
    }

    static JsonArray onRows(JsonArray input, JsonObject rows) {
        JsonArray result = new JsonArray();
        if (rows.isEmpty()) {
            result.addAll(input);
        } else {
            Sc.infoAuth(LOGGER, "DataRegion Rows -> {0}", rows.encode());
            input.stream().filter(Objects::nonNull).map(item -> (JsonObject)item).filter(item -> SiftRow.isMatch(item, rows)).forEach(arg_0 -> ((JsonArray)result).add(arg_0));
        }
        return result;
    }

    private static boolean isMatch(JsonObject item, JsonObject rows) {
        return rows.fieldNames().stream().anyMatch(field -> {
            Object inputValue = item.getValue(field);
            JsonArray rowsArray = rows.getJsonArray(field);
            return rowsArray.contains(inputValue);
        });
    }
}

