/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.extension;

import cn.vertxup.rbac.service.accredit.MatrixStub;
import io.vertx.core.Future;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.rbac.acl.region.CommonCosmo;
import io.vertx.tp.rbac.acl.region.Cosmo;
import io.vertx.tp.rbac.acl.region.SeekCosmo;
import io.vertx.tp.rbac.logged.ScUser;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.commune.Envelop;
import io.vertx.up.extension.region.AbstractRegion;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class DataRegion
extends AbstractRegion {
    private static final ConcurrentMap<String, Cosmo> POOL_COMMON = new ConcurrentHashMap<String, Cosmo>();
    private static final ConcurrentMap<String, Cosmo> POOL_SEEK = new ConcurrentHashMap<String, Cosmo>();
    @Inject
    private transient MatrixStub stub;

    public Future<Envelop> before(RoutingContext context, Envelop envelop) {
        if (this.isEnabled(context)) {
            return this.cacheView(context, envelop).compose(matrix -> {
                if (this.hasValue((JsonObject)matrix)) {
                    Sc.infoAuth(this.getLogger(), "--> DataRegion Before: uri = {0}, region = {1}", context.request().path(), matrix.encode());
                    HttpMethod method = envelop.method();
                    if (HttpMethod.POST == method || HttpMethod.GET == method) {
                        Cosmo cosmo = this.cosmo((JsonObject)matrix);
                        return cosmo.before(envelop, (JsonObject)matrix);
                    }
                    return Ux.future((Object)envelop);
                }
                return Ux.future((Object)envelop);
            });
        }
        return Ux.future((Object)envelop);
    }

    public Future<Envelop> after(RoutingContext context, Envelop response) {
        if (this.isEnabled(context)) {
            return this.cacheView(context, response).compose(matrix -> {
                if (this.hasValue((JsonObject)matrix)) {
                    Sc.infoAuth(this.getLogger(), "<-- DataRegion After: {0}", matrix.encode());
                    Cosmo cosmo = this.cosmo((JsonObject)matrix);
                    return cosmo.after(response, (JsonObject)matrix);
                }
                return Ux.future((Object)response);
            });
        }
        return Ux.future((Object)response);
    }

    private Future<JsonObject> cacheView(RoutingContext context, Envelop envelop) {
        String habitus = envelop.token("habitus");
        if (Ut.isNil((String)habitus)) {
            return Ux.future((Object)new JsonObject());
        }
        String viewKey = Ke.keyView((RoutingContext)context);
        ScUser scUser = ScUser.login(habitus);
        return scUser.view(viewKey);
    }

    private boolean hasValue(JsonObject matrix) {
        if (Objects.isNull(matrix)) {
            return false;
        }
        boolean hasValue = Ut.notNil((JsonArray)matrix.getJsonArray("projection", new JsonArray()));
        if (hasValue) {
            return true;
        }
        hasValue = Ut.notNil((JsonArray)matrix.getJsonArray("credit", new JsonArray()));
        if (hasValue) {
            return true;
        }
        hasValue = Ut.notNil((JsonObject)matrix.getJsonObject("rows", new JsonObject()));
        if (hasValue) {
            return true;
        }
        return Ut.notNil((JsonObject)matrix.getJsonObject("criteria", new JsonObject()));
    }

    private Cosmo cosmo(JsonObject matrix) {
        if (matrix.containsKey("seeker")) {
            return (Cosmo)Fn.poolThread(POOL_SEEK, SeekCosmo::new);
        }
        return (Cosmo)Fn.poolThread(POOL_COMMON, CommonCosmo::new);
    }
}

