/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.logged;

import io.vertx.core.Future;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.rbac.atom.ScConfig;
import io.vertx.tp.rbac.init.ScPin;
import io.vertx.up.atom.secure.Vis;
import io.vertx.up.unity.Ux;
import io.vertx.up.unity.UxPool;

public class ScResource {
    private static final ScConfig CONFIG = ScPin.getConfig();
    private final transient UxPool pool;
    private final transient String resourceKey;
    private final transient String uri;
    private final transient String requestUri;
    private final transient String sigma;
    private final transient Vis view;
    private final transient HttpMethod method;

    private ScResource(JsonObject data) {
        JsonObject metadata = data.getJsonObject("metadata");
        String uri = metadata.getString("uri");
        this.requestUri = metadata.getString("requestUri");
        this.method = HttpMethod.valueOf((String)metadata.getString("method"));
        this.uri = Ke.uri((String)uri, (String)this.requestUri);
        this.view = Vis.smart((Object)metadata.getValue("view"));
        if (CONFIG.getSupportMultiApp().booleanValue()) {
            JsonObject headers = data.getJsonObject("headers");
            this.sigma = headers.getString("X-Sigma");
        } else {
            this.sigma = null;
        }
        this.resourceKey = Ke.keyResource((String)this.method.name(), (String)this.uri);
        this.pool = Ux.Pool.on((String)CONFIG.getResourcePool());
    }

    public static ScResource create(JsonObject data) {
        return new ScResource(data);
    }

    public String uri() {
        return this.uri;
    }

    public String uriRequest() {
        return this.requestUri;
    }

    public String sigma() {
        return this.sigma;
    }

    public Vis view() {
        return this.view;
    }

    public String key() {
        return this.resourceKey;
    }

    public String keyView() {
        return Ke.keyView((String)this.method.name(), (String)this.uri, (Vis)this.view);
    }

    public HttpMethod method() {
        return this.method;
    }

    public boolean isNormalized() {
        return !this.requestUri.equals(this.uri);
    }

    public Future<JsonObject> resource() {
        return this.pool.get((Object)this.resourceKey);
    }

    public Future<JsonObject> resource(JsonObject data) {
        return this.pool.put((Object)this.resourceKey, (Object)data).compose(item -> Ux.future((Object)((JsonObject)item.getValue())));
    }
}

