/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.logged;

import cn.vertxup.rbac.domain.tables.daos.RRolePermDao;
import cn.vertxup.rbac.domain.tables.pojos.RRolePerm;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.tp.rbac.atom.ScConfig;
import io.vertx.tp.rbac.init.ScPin;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.unity.UxPool;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class ScRole {
    private static final ConcurrentMap<String, ScRole> ROLES = new ConcurrentHashMap<String, ScRole>();
    private static final Annal LOGGER = Annal.get(ScRole.class);
    private static final ScConfig CONFIG = ScPin.getConfig();
    private final transient UxPool pool;
    private final transient String roleId;
    private final transient Set<String> authorities = new HashSet<String>();

    private ScRole(String roleId) {
        this.roleId = roleId;
        this.pool = Ux.Pool.on((String)CONFIG.getPermissionPool());
    }

    public static ScRole login(String roleId) {
        return (ScRole)Fn.pool(ROLES, (Object)roleId, () -> new ScRole(roleId));
    }

    public String key() {
        return this.roleId;
    }

    public Set<String> authorities() {
        return this.authorities;
    }

    public Future<JsonArray> clear() {
        ROLES.remove(this.roleId);
        return this.pool.remove((Object)this.roleId).compose(item -> Ux.future((Object)((JsonArray)item.getValue())));
    }

    public Future<JsonArray> fetchWithCache() {
        return this.permission().compose(permissions -> {
            if (Objects.isNull(permissions)) {
                return this.fetch().compose(this::permission);
            }
            Sc.infoAuth(LOGGER, "ScRole \u001b[0;37m----> Cache key = {0}\u001b[m.", this.roleId);
            permissions.stream().map(item -> (String)item).forEach(this.authorities::add);
            return Ux.future((Object)permissions);
        });
    }

    public Future<JsonArray> fetch() {
        return Ux.Jooq.on(RRolePermDao.class).fetchAsync("roleId", (Object)this.roleId).compose(permissions -> Ux.future((Object)this.authorities((List<RRolePerm>)permissions)));
    }

    public void refresh() {
        List queried = Ux.Jooq.on(RRolePermDao.class).fetch("roleId", (Object)this.roleId);
        this.authorities(queried);
    }

    public Future<JsonArray> refresh(JsonArray permissions) {
        return this.permission(permissions);
    }

    private JsonArray authorities(List<RRolePerm> permissions) {
        List permissionIds = permissions.stream().filter(Objects::nonNull).map(RRolePerm::getPermId).collect(Collectors.toList());
        this.authorities.clear();
        this.authorities.addAll(permissionIds);
        return Ut.toJArray(permissionIds);
    }

    private Future<JsonArray> permission() {
        return this.pool.get((Object)this.roleId);
    }

    private Future<JsonArray> permission(JsonArray permission) {
        return this.pool.put((Object)this.roleId, (Object)permission).compose(item -> Ux.future((Object)((JsonArray)item.getValue())));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScRole scRole = (ScRole)o;
        return this.roleId.equals(scRole.roleId);
    }

    public int hashCode() {
        return Objects.hash(this.roleId);
    }

    public String toString() {
        return "ScRole{roleId='" + this.roleId + "', authorities=" + this.authorities + "}";
    }
}

