/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.api;

import cn.vertxup.rbac.service.login.AuthStub;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Session;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Queue;
import io.vertx.up.atom.unity.UObject;
import io.vertx.up.commune.config.XHeader;
import io.vertx.up.exception.web._501NotSupportException;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import java.util.Objects;
import javax.inject.Inject;

@Queue
public class AuthActor {
    @Inject
    private transient AuthStub stub;

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/O-LOGIN")
    public Future<JsonObject> login(JsonObject user, XHeader header) {
        JsonObject params = user.copy();
        return Sc.imageVerify(header.session(), params, this.stub::login);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/O-AUTHORIZE")
    public Future<JsonObject> authorize(JsonObject data) {
        return this.stub.authorize(UObject.create((JsonObject)data).denull().remove(new String[]{"response_type"}).convert("client_id", "clientId").convert("client_secret", "clientSecret").to());
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/O-TOKEN")
    public Future<JsonObject> token(JsonObject data, Session session) {
        return this.stub.token(data.copy(), session);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-CAPTCHA/IMAGE/VERIFY")
    public Future<Boolean> imageVerity(JsonObject request, XHeader header) {
        Fn.out((boolean)Objects.isNull(header.session()), _501NotSupportException.class, (Object[])new Object[]{this.getClass()});
        return Sc.imageVerify(header.session(), request, normalized -> Ux.futureT());
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-CAPTCHA/IMAGE")
    public Future<Buffer> generateImage(XHeader header) {
        Fn.out((boolean)Objects.isNull(header.session()), _501NotSupportException.class, (Object[])new Object[]{this.getClass()});
        return Sc.imageOn(header.session(), 180, 40);
    }
}

