/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.api;

import cn.vertxup.rbac.service.batch.IdcStub;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.excel.ExcelClient;
import io.vertx.tp.plugin.excel.atom.ExRecord;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Plugin;
import io.vertx.up.annotations.Queue;
import io.vertx.up.commune.Envelop;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Queue
public class FileActor {
    @Plugin
    private transient ExcelClient client;

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-IMPORT/USER")
    public Future<Envelop> importFile(Envelop request) {
        String filename = Ux.getString((Envelop)request);
        Promise promise = Promise.promise();
        File file = new File(filename);
        if (file.exists()) {
            Fn.safeJvm(() -> {
                JsonObject headers = request.headersX().copy();
                FileInputStream inputStream = new FileInputStream(file);
                Set tables = this.client.ingest((InputStream)inputStream, true).stream().filter(Objects::nonNull).filter(item -> Objects.nonNull(item.getName())).filter(item -> item.getName().equals("S_USER")).collect(Collectors.toSet());
                JsonArray prepared = new JsonArray();
                tables.stream().flatMap(table -> {
                    List records = table.get().stream().filter(Objects::nonNull).map(ExRecord::toJson).collect(Collectors.toList());
                    Sc.infoWeb(this.getClass(), "Table: {0}, Records: {1}", table.getName(), String.valueOf(records.size()));
                    return records.stream();
                }).forEach(record -> {
                    record.mergeIn(headers, true);
                    if (Ut.isIn((JsonObject)record, (String[])new String[]{"username"})) {
                        record.put("language", (Object)"cn");
                        prepared.add(record);
                    } else {
                        Sc.warnWeb(this.getClass(), "Ignored record: {0}", record.encode());
                    }
                });
                String sigma = headers.getString("sigma");
                IdcStub stub = IdcStub.create(sigma);
                String user = request.userId();
                return stub.saveAsync(prepared, user);
            });
        } else {
            promise.complete((Object)Envelop.success((Object)Boolean.FALSE));
        }
        return promise.future();
    }
}

